#ifndef lint
static char SCCSid[] = "@(#) ./blkcm/copy/util2dad.c 07/23/93";
#endif

/* 
    This file contains routines for moveing data from one slab to 
    another.  Inorder to make motion to/from a communications
    buffer efficient, special cases for compacted (unit stride)
    storage are included.
 */

#include "blkcm/bcp.h"

BCs_to_d2dadd( s, d )
slab *s, *d;
{
register double *sp1 = s->p;
register double *dp1 = d->p;
register double *sp, *dp;
register int    n2, n1, dinc = d->s1, sinc = s->s1;

n2 = s->n2;
while (n2--) {
    n1 = s->n1;
    dp = dp1;
    sp = sp1;
    while (n1--) {
	*dp += *sp;
	dp  += dinc;
	sp  += sinc;
	}
    dp1 += d->inc1;
    sp1 += s->inc1;
    }
}

BCb_to_d2dadd( b, d )
slab   *d;
double *b;
{
register double *sp = b;
register double *dp1 = d->p;
register double *dp;
register int    n2, n1, dpinc = d->s1;

n2 = d->n2;
while (n2--) {
    n1 = d->n1;
    dp = dp1;
    while (n1--) {
	*dp += *sp++;
	dp  += dpinc;
	}
    dp1 += d->inc1;
    }
}

