#ifndef lint
static char SCCSid[] = "@(#) ./blkcm/copy/util.c 07/23/93";
#endif

/* 
    This file contains routines for moveing data from one slab to 
    another.  Inorder to make motion to/from a communications
    buffer efficient, special cases for compacted (unit stride)
    storage are included.

    These copy routines can use either  
      1. straighforward copy loops
      2. calls to routines (dcopy)       (define BLAS)
      3. "duff's device" (unrolled loop with a fast handler for the
         "leftover" part).               (define DUFF)

    Versions of these for the 5-d loops need to be provided; actually,
    1-d, 2-d, ..., 5-d should be provided, with the max-d the ones selected.
 */

#include "tools.h"
#include "blkcm/bc.h"
#include "blkcm/bcp.h"

/* This needs to be changed to use the sizeof an element */
int BCmsg_len( s )
slab *s;
{
return s->n5 * s->n4 * s->n3 * s->n2 * s->n1 * sizeof(double);
}

/*
   This routine sets the transfer functions (if non-null)
 */
BCset_trans( Program, local, send, recv )
BCPGM *Program;
int (*local)(), (*send)(), (*recv)();
{
if (local) Program->copy = local;
if (send)  Program->out  = send;
if (recv)  Program->in   = recv;
}

/*ARGSUSED*/
/* 
   This allows use to use BCset5d for all definitions but only use
   a lower-dimensioned copy if the higher dimensions are always 1
 */
BCSetMaxdim( Program, n1, n2, n3, n4, n5 )
BCPGM *Program;
int   n1, n2, n3, n4, n5;
{
int md = 1;

if      (n5 != 1) md = 5;
else if (n4 != 1) md = 4;
else if (n3 != 1) md = 3;
else if (n2 != 1) md = 2;
if (Program->maxdim < md) Program->maxdim = md;
}
