#ifndef lint
static char     SCCSid[] = "@(#) ./xtools/text/text.c 07/23/93";
#endif

#include <stdio.h>
#include "tools.h"
#include "xtools/basex11.h"

/*
   This file contains routines to manage fonts.  There are two separate
   approaches here:

   A set of default, fixed-width fonts is provided.

   The ability to load an arbitrary, variable-width font (not yet available)

   The approach is:

   XBInitFonts( XBWin ) - acquires info on (some of) the available fixed
                          width fonts.
   XBMatchFontSize( font, w, h ) - find a font that matches the width and
                                   height
   XBLoadFont( XBWin, font ) - loads a particular font
   XBDrawText( XBWin, font, x, y, chrs ) - write text
 */

/* this is set by XListFonts at startup */
#define NFONTS 20
static struct {
    int w, h, descent;
    } nfonts[NFONTS];
static int act_nfonts = 0;

/*@
    XBDrawText - Draw text in the given window at the given coordinates.

    Input Parameters:
.   XBWin - window
.   font  - font 
.   x,y   - location of left edge of character string
.   chrs  - characters to draw

    Note:
    Text should be justified and/or clipped before calling this
    routine.  The font to use should have been set with the XBLoadFont call
    (or XBFontFixed).
@*/
void XBDrawText( XBWin, font, x, y, chrs )
XBWindow    *XBWin;
XBFont      *font;
int         x, y;
char        *chrs;
{
XDrawString( XBWin->disp, XBDrawable(XBWin), XBWin->gc.set,
             x, y - font->font_descent, chrs, strlen(chrs) );
}


/*
 * These routines determine the font to be used based on the requested size,
 * and load it if necessary
 */

void XBLoadFont( XBWin, font )
XBWindow    *XBWin;
XBFont      *font;
{
char        font_name[100];
XFontStruct *FontInfo;

(void) sprintf(font_name, "%dx%d", font->font_w, font->font_h );
/* printf( "font num is %d in loadfont\n", fnum ); */
/* printf( "font names is %s\n", font_name ); */
font->fnt  = XLoadFont( XBWin->disp, font_name );

/* The font->descent may not have been set correctly; get it now that
   the font has been loaded */
FontInfo   = XQueryFont( XBWin->disp, font->fnt );
font->font_descent   = FontInfo->descent;

/* For variable width, also get the max width and height */

/* Storage leak; should probably just free FontInfo? */
/* XFreeFontInfo( FontInfo ); */
}


/* Code to find fonts and their characteristics */
void XBInitFonts( XBWin )
XBWindow *XBWin;
{
char    **names;
int     cnt, i, j;
XFontStruct  *info;


/* This just gets the most basic fixed-width fonts */
names   = XListFontsWithInfo( XBWin->disp, "?x??", NFONTS, &cnt, &info );
j       = 0;
for (i=0; i < cnt; i++) {
    /*printf( "in XBInitFonts - found font %s\n", names[i] ); */
    names[i][1]         = '\0';
    nfonts[j].w         = info[i].max_bounds.width ;
    nfonts[j].h         = info[i].ascent + info[i].descent;
    nfonts[j].descent   = info[i].descent;
    /* printf( "w = %d, h = %d\n", nfonts[j].w, nfonts[j].h ); */
    if (nfonts[j].w <= 0 || nfonts[j].h <= 0) continue;
    j++;
    }
act_nfonts    = j;
if (cnt > 0)
    {
    XFreeFontInfo( names, info, cnt );
#ifndef IRIX
    /* This causes IRIX to barf */
    XFreeFontNames( names );
#endif
    }
/* If the above fails, try this: */
if (act_nfonts == 0) {
    XFontStruct *info;
    /* This just gets the most basic fixed-width fonts */
    names   = XListFontsWithInfo( XBWin->disp, "?x", NFONTS, &cnt, &info );
    j       = 0;
    for (i=0; i < cnt; i++) {
        if (strlen(names[i]) != 2) continue;
        /* printf( "found font %s\n", names[i] ); */
        names[i][1]         = '\0';
	nfonts[j].w         = info[i].max_bounds.width ;
        /* nfonts[j].w         = info[i].max_bounds.lbearing +
                                    info[i].max_bounds.rbearing; */
        nfonts[j].h         = info[i].ascent + info[i].descent;
        nfonts[j].descent   = info[i].descent;
        /* printf( "w = %d, h = %d\n", nfonts[j].w, nfonts[j].h ); */
        if (nfonts[j].w <= 0 || nfonts[j].h <= 0) continue;
        j++;
        }
    act_nfonts    = j;
    XFreeFontInfo( names, info, cnt );
    XFreeFontNames( names );
    }
}

void XBMatchFontSize( font, w, h )
XBFont      *font;
int         w, h;
{
int i;

for (i=0; i<act_nfonts; i++) {
    if (nfonts[i].w == w && nfonts[i].h == h) {
        font->font_w        = w;
        font->font_h        = h;
        font->font_descent  = nfonts[i].descent;
        return;
        }
    }

fprintf( stderr, "Warning could not match to font of %d fonts\n", act_nfonts );
fprintf( stderr, "Wanted Size %d %d Using %d %d \n", w, h, nfonts[0].w,
                                                           nfonts[0].h);
/* should use font with closest match */
font->font_w        = nfonts[0].w;
font->font_h        = nfonts[0].h;
font->font_descent  = nfonts[0].descent;
}
