#ifndef lint
static char SCCSid[] = "@(#) ./xtools/solid/lighting.c 07/23/93";
#endif

#include "tools.h"
#include "xtools/basex11.h"
#include "xtools/base3d.h"
#include <math.h>

/* 
 This file contains routines to compute some simple lighting models,
 using ramped color tables and the triangle decompositions.
 */
#define CROSS(a,b,c) {c[0] = a[1]*b[2]-a[2]*b[1];\
c[1]=a[2]*b[0]-a[0]*b[2];c[2]=a[0]*b[1]-a[1]*b[0];}
#define DOT(a,b) (a[0]*b[0]+a[1]*b[1]+a[2]*b[2])
/* scale is by multiply in this version */
#define SCALE(a,b) {a[0] *= b; a[1] *= b; a[2] *= b;}

/* @
    XBLightModelMono - set the effective color of a GraphObject given a light
                       source and a monochrome object

    Input Parameters:
    Obj        - Graph object
    Light      - Light

    Algorithm:
    We compute the surface normal for each triangle.
    The intensity model is
    I = I  + I  lvec . sur_normal / (1 + ldist)
         a    l
    The intensity model isn't physical, but does model a farther away light.
 @ */
void XBLightModel( Obj, Light )
XBGraphObject *Obj;
XBLightSource *Light;
{
/* Q: do this for ALL triangles or just the visable ones?  Just the visable ones
   if the light source moves frequently, all if the viewpoint moves
   frequently */
int        nt, i, j;
XBxyz      *a1, *a2, *a3, SurNormal, S1, S2, Center, Lvec;
XBTriangle *tri = Obj->t;
XBVertices *v = &Obj->v;
double     sdots, ldist, ivec, i_amb, i_light;

nt  = Obj->nt;
for (i=0; i<nt; i++) {
    /* Compute the surface normal and the vector from the
       center of the triangle to the light */
    a1 = XBVertexXYZ(XBVertexIndex1(tri),v);
    a2 = XBVertexXYZ(XBVertexIndex2(tri),v);
    a3 = XBVertexXYZ(XBVertexIndex3(tri),v);
    XBVXA(S1)     = XBVX(a2) - XBVX(a1);
    XBVXA(S2)     = XBVX(a3) - XBVX(a1);
    XBVXA(Center) = (XBVX(a1) + XBVX(a2) + XBVX(a3)) / 3.0;
    XBVYA(S1)     = XBVY(a2) - XBVY(a1);
    XBVYA(S2)     = XBVY(a3) - XBVY(a1);
    XBVYA(Center) = (XBVY(a1) + XBVY(a2) + XBVY(a3)) / 3.0;
    XBVZA(S1)     = XBVZ(a2) - XBVZ(a1);
    XBVZA(S2)     = XBVZ(a3) - XBVZ(a1);
    XBVZA(Center) = (XBVZ(a1) + XBVZ(a2) + XBVZ(a3)) / 3.0;
    
    /* For each light ... */
    XBVXA(Lvec)   = XBVXA(Center) - XBVXA((Light->xyz));
    XBVYA(Lvec)   = XBVYA(Center) - XBVYA((Light->xyz));
    XBVZA(Lvec)   = XBVZA(Center) - XBVZA((Light->xyz));

    CROSS( S1, S2, SurNormal );
    sdots = sqrt( DOT( SurNormal, SurNormal ) );
    SCALE( SurNormal, 1.0/sdots );
    ldist = sqrt( DOT( Lvec, Lvec ) );
    SCALE( Lvec, 1.0/ldist );

    /* This is correct for a point-source.  A diffuse source can be
       modeled by computing a range of ivec values for some points about
       the center of the light (suitably weighted and combined). */
    ivec = - DOT( Lvec, SurNormal );
    ivec = ivec / (1 + ldist);
    i_amb   = 1;   /* Should come from light */

    /* (we also normalize the light intensity so that the distance term does not
       affect the closest point) */
    /*     i_light = nc * (1 + minval(ldist)) */
    i_light = Light->intens;
    ivec    = i_amb + i_light * ivec;
    /* This should really do this for each of red, green, and blue,
       and set the color as that triple.  Then that triple can be mapped
       into colormap values by a separate step. */
    /* Accumulate for each light... */

/*     if (ivec >= numcolors) ivec = numcolors - 1; */
    if (ivec < 0) ivec = 0;
    
    /* 
    tri[nt].discolor = XBWin->cmapping[ivec]; */
    /* Match to color values */
    tri[nt].discolor = ivec;
    }
}


/* @
    XBBaseLightModel - set the effective color assuming no lighting effects.

    Input Parameters:
    Obj        - Graph object
 @ */
void XBBaseLightModel( Obj )
XBGraphObject *Obj;
{
int        nt, i;
XBTriangle *tri = Obj->t;

nt  = Obj->nt;
for (i=0; i<nt; i++) {
    tri->discolor = tri->color;
    tri++;
    }
}

