#ifndef lint
static char SCCSid[] = "@(#) ./xtools/papps/qpcntr.c 07/23/93";
#endif

#include <stdio.h>
#include "tools.h"
#include "comm/comm.h"               /*I "comm/comm.h" I*/
#include "xtools/basex11.h"
#include "xtools/papps/papps.h"
#include <math.h>


/*@
    XBPQContour - display a contour plot on the display from parallel,
                  distributed data

     Input Parameters:
.     mesh - mesh of values
.     x,y  - coordinates of mesh
.     nx,ny - size of mesh (global value)
.     nc    - number of colors
.     si,ei - local limits in the first dimension
.     sj,ej - local limits in the second dimension

     Note:
     This uses the "quick" window; if there is no "quick" window, 
     one is created.  You may need to set the local X display host, and
     use "xhost + nodenames" to allow them to access the window.

     Bug:
     The boundaries between the domains are not computed correctly.
     Specifically, we really need the values of some of the neighbors
     in order to fill in those cells.  
@*/
void XBPQContour( mesh, x, y, nx, ny, nc, si, ei, sj, ej, procset )
double  *mesh, *x, *y;
int     nx, ny, nc, si, ei, sj, ej;
ProcSet *procset;
{
int    i, j, n;
double *px = 0, *py = 0, maxv, minv, imap[256];
XBWindow *XBWin = XBPQGetWindow( "Contour", "" );
unsigned char *map;
int    mx, my, w, h, wx, wy;
double lims[2], wlims[2];

/* Check to see if everyone was able to open the display */
i = (XBWin != 0);
GISUM( &i, 1, &j, ALLPROCS );
if (i != NUMNODES) {
    if (MYPROCID == 0) {
	fprintf( stderr, 
     "Could not open DISPLAY from all nodes.  Check your xhost settings.\n" );
	}
    exit(0);
    }
mx = ei - si + 1;
my = ej - sj + 1;

/* Generate a copy of mesh that is scaled into [-1,1] */
n    = mx * my;
minv = maxv = mesh[0];
for (i=0; i<n; i++) {
    if (mesh[i] > maxv) maxv = mesh[i];
    else if (mesh[i] < minv) minv = mesh[i];
    }
lims[0] = maxv;
lims[1] = -minv;
GDMAX( lims, 2, wlims, procset );
maxv = lims[0];
minv = -lims[1];

/* if x,y, null, generate those too */
px = (double *)MALLOC( mx * sizeof(double) );      CHKPTR(px);
py = (double *)MALLOC( my * sizeof(double) );      CHKPTR(py);

if (!x) 
    for (i=0; i<mx; i++) px[i] = i*(1.0/(mx-1));
else {
    MEMCPY( px, x, mx*sizeof(double) );
    }
if (!y)
    for (j=0; j<my; j++) py[j] = j*(1.0/(my-1));
else {
    MEMCPY( py, y, my*sizeof(double) );
    }

/* Compute our map size.  Currently, this assmes that the mesh is regularly
   spaced */
w = (XBWin->w * mx) / (nx-1);
h = (XBWin->h * my) / (ny-1);
/* Compute the location of the image */
wx = (si * XBWin->w) / (nx-1);
/* wy = XBWin->h - (ej * XBWin->h) / (ny-1); */
wy = sj * XBWin->h / (ny-1);
if (wx + w >= XBWin->w) 
    w = XBWin->w - wx - 1;
if (wy + h >= XBWin->h) 
    h = XBWin->h - wy - 1;
map = (unsigned char *) MALLOC( w * h );    CHKPTR(map);

/* Compute the color map breakpoints.  Since everyone is using the same
   mins and maxes, everyone will compute the same values (we could 
   just scatter this as well) */
for (i=0; i<nc; i++) 
    imap[i] = (double)(i + 1)*(maxv - minv) / nc + minv;

XBUniformHues( XBWin, nc + 2 );

/* printf( "[%d] mx=%d my=%d wx=%d wy=%d\n", MYPROCID, mx, my, wx, wy ); */
XBContourDrawWithMap( XBWin, mesh, mx, my, px, py, imap, nc, map, 
                      w, h, wx, wy, 1 );
XBFlush( XBWin );
FREE( map );
if (px) FREE( px );
if (py) FREE( py );
}
