#ifndef LINT
static char SCCSid[] = "@(#) ./xtools/matrix/matrix.c 07/23/93";
#endif
/*
    This file creates a matrix map.
    We allow for the user to draw submatrix maps within a "matrix" tool.
 */

#include "tools.h"
#include "xtools/basex11.h"
#include "sparse/spmat.h"

/* Forward references */
void XBiDrawMatrixRow();
void XBiTextMatrixRow();
typedef struct {
    XBFont font;
    } XBiTextCtx;

/* Here is the first pass at a routine to generate the locations of the
   rows/columns from the tools sizes.  Note that only a single routine 
   is needed.  Also note that this could be replaced with a bresenham
   like algorithm for the computation of the locations.
 */
void XBISetLocations( n, w, nf, off, loc )
int n, nf, w, off, *loc;
{
int i;
for (i=0; i<n; i++) 
    loc[i] = off + i * w / nf;
}

/*
   Here is the basic routine to draw a matrix 
 */
void XBMatrixBaseDraw( XBWin, mat, n, imap, ncolor, sr, er, sc, ec )
XBWindow *XBWin;
SpMat    *mat;
int      n, ncolor, sr, er, sc, ec;
double   *imap;
{
int          row, lastcol, icol, col, x, y, colwid, rowwid;
int          nr, nc;
int          *xloc, *yloc;
int          *ja;
double       *a;
unsigned int coloridx;
int          nz;

XSetForeground( XBWin->disp, XBWin->gc.set, XBWin->background );
XFillRectangle( XBWin->disp, XBDrawable(XBWin), XBWin->gc.set,
                XBWin->x, XBWin->y, XBWin->w, XBWin->h );

if (n <= 0) return;

nr = er - sr + 1;
nc = ec - sc + 1;
if (nr <= 0 || nc <= 0) return;

/* Note that rectangles in X don't actually include the last pixels */
colwid = XBWin->w / nc + 1;
rowwid = XBWin->h / nr + 1;
if (colwid <= 1) colwid = 2;
if (rowwid <= 1) rowwid = 2;

xloc = (int*)MALLOC( ((er-sr+1)+(ec-sc+1))*sizeof(int) ); CHKPTR(xloc);
yloc = xloc + (ec-sc+1);
XBISetLocations( er - sr + 1, XBWin->h, nr, XBWin->y, yloc );
XBISetLocations( ec - sc + 1, XBWin->w, nc, XBWin->x, xloc );
if (XBWin->numcolors == 2)
    XSetForeground( XBWin->disp, XBWin->gc.set, XBWin->foreground );

for (row=sr; row<=er; row++) {
    SpScatterFromRow( mat, row, &nz, &ja, &a );
    XBiDrawMatrixRow( XBWin, ja, a, nz, sc, ec, xloc, yloc[row-sr], 
		      imap, ncolor, colwid, rowwid, (void *)0 );
    }
FREE( xloc );
}

/* Do a single row; allows customization for special handling of rows:
   ja,a,nz - from ScatterFromRow
   sc,ec   - start/end column to display
   xloc    - array that maps columns in matrix to columns in window
   y       - location of row in window
   imap,ncolor - for color mapping
   colwid,rowwid - size of each entry
   ctx     - special context
 */
void XBiDrawMatrixRow( XBWin, ja, a, nz, sc, ec, xloc, y, imap, ncolor, colwid,
		       rowwid, ctx )
XBWindow *XBWin;
int      *ja, nz, sc, ec, *xloc, y, ncolor, colwid, rowwid;
double   *a, *imap;
void     *ctx;
{
int icol, col, x;
unsigned int coloridx;

for (icol=0; icol<nz; icol++) {
    col = ja[icol];
    if (col < sc || col > ec) continue;
    
    /* convert row and col to coordinates in the window */
    /* We could do this by doing a lookup (one for column, one for row),
       particularly for matrices that are not very sparse.  Note in that
       case that few divisions would be needed, since the arrays 
       can be generated by Bresenham's algorithm */
    x = xloc[col-sc];
	   
    /* convert the value of the matrix to the appropriate color */
    /* Another way to potentially speed things up is to only do
       one color at a time */
    if (XBWin->numcolors > 2) {
	coloridx = XBGetimap( imap, ncolor, a[icol] ) >> 6;
	/* printf( "[%d,%d] color %d (value %f)\n", 
	   row, col, coloridx, a[icol] ); */
	XSetForeground( XBWin->disp, XBWin->gc.set, 
		       XBWin->cmapping[coloridx] );
	}
    XFillRectangle( XBWin->disp, XBDrawable(XBWin), XBWin->gc.set,
		   x, y, colwid, rowwid );
    }
}

/* Do a single row; allows customization for special handling of rows:
   ja,a,nz - from ScatterFromRow
   sc,ec   - start/end column to display
   xloc    - array that maps columns in matrix to columns in window
   y       - location of row in window
   imap,ncolor - for color mapping
   colwid,rowwid - size of each entry
   ctx     - special context

   This version draws text
 */
void XBiTextMatrixRow( XBWin, ja, a, nz, sc, ec, xloc, y, imap, ncolor, colwid,
		       rowwid, ctx )
XBWindow *XBWin;
int      *ja, nz, sc, ec, *xloc, y, ncolor, colwid, rowwid;
double   *a, *imap;
void     *ctx;
{
int    icol, col, x;
char   chrs[200];
XBFont *font = &((XBiTextCtx *)ctx)->font;

for (icol=0; icol<nz; icol++) {
    col = ja[icol];
    if (col < sc || col > ec) continue;
    x = xloc[col-sc];
    sprintf( chrs, "%e", a[icol] );
    XBDrawText( XBWin, font, x, y, chrs );
    }
}

