#include <stdio.h>
#include "tools.h"
#include "xtools/basex11.h"
#define NO_GENERIC_SPARSE
#include "sparse/spmat.h"
#include "fd/fd.h"

#include <math.h>

#define X_SIZE 11
#define Y_SIZE 13

main( argc, argv )
int argc;
char **argv;
{
XBWindow *XBWin;
double   imap[256];
int      i, j;
SpMat    *mat;
int      sc, ec, sr, er, n;
int      ncolor = 16;
int      px = -1, py = -1, pw = 200, ph = 200;

XBWin = XBWinCreate();
if (SYArgHasName( &argc, argv, 1, "-help" )) {
    fprintf( stderr, "%s Matrix example\n", argv[0] );
    exit(0);
    }
SYArgGetInt( &argc, argv, 1, "-nc", &ncolor );
XBGetArgs( &argc, argv, 1, &px, &py, &pw, &ph );
if (XBQuickWindow( XBWin, "", "Matrix", px, py, pw, ph )) {
    fprintf( stderr, "Check your DISPLAY variable\n" );
    exit(0);
    }

/* Setup the data */
mat = FDBuildLaplacian2d( 10, 10, 0.0, 0.0, 0.0 );
n   = 100;
for (i=0; i<ncolor; i++) 
    imap[i] = -4.0 + (double)(i) * (8.0 / (ncolor-1));
sr = 0; 
er = n-1;
sc = 0;
ec = n-1;
XBMatrixBaseDraw( XBWin, mat, n, imap, ncolor, sr, er, sc, ec );
XBFlush( XBWin );
sleep(5);
}

