#ifndef lint
static char SCCSid[] = "@(#) ./xtools/apps/xres.c 07/23/93";
#endif

#include <math.h>
#include "tools.h"
#include "iter/itall.h"           /*I "iter/itall.h" I*/
#include "xtools/basex11.h"
#include "xtools/lines/lines.h" 
#include "xtools/axis/axis.h"

/* 
   This file contains a simple routine to display the progress of the
   residual in an X window
 */

static Lines    *lines = 0;
static XBWindow *XBWin = 0;
static XBAxisData *Xad = 0;
static XBWindow XWinSave;
static int      maxits = 0;
static double   minres = 0.0;
static double   maxres = 0.0;

/*ARGSUSED*/
/*@C
  ITXMonitor - Simple X Windows code to display the residual at each iteration 
  in the iterative solvers.

  Input Parameters:
. itP   - iterative context
. usrP  - user's context
. n     - iteration number.  If < 0, initialize the display
. rnorm - 2-norm residual value (may be estimated).  

  Note:
  By default, this routine autoscales at each iterate.  To set the default
  scales, use ITXMonitorLimits
 @*/
void ITXMonitor( itP, usrP, n, rnorm )
ITCntx *itP;
void   *usrP;
int    n;
double rnorm;
{
double x, y;

if (n < 0) {
    /* Setup call */
    if (n < -1) {
	/* Initial setup */
	maxres = 0.0;
	minres = 0.0;
	}
    if (lines) {
	XBLinesFree( lines );
	lines = 0;
	}
    if (!XBWin) {
	XBWin = XBQGetWindow( "Residual", "" );
	if (XBWin) XWinSave = *XBWin;
	}
    if (!XBWin) return;
    *XBWin = XWinSave;
    XBClearWindow( XBWin, 0, 0, XBWin->w, XBWin->h );
    if (!Xad) XBADestroyAxis( Xad );
    Xad = XBAInitAxis( XBWin, XBFontFixed( XBWin, 7, 13 ) );
    if (n < -1) return;
    }
if (!XBWin) return;
if (!lines) lines = XBLinesInit();

x = (double)n;
if (rnorm <= 0.0) 
    y = -300.0;
else
    y = log10( rnorm );
XBLinesAddLines( lines, &x, &y, 1, XBWin->foreground );
if (maxits > 0 || minres != 0.0) {
    if (y < minres) minres = y;
    if (y > maxres) maxres = y;
    XBLinesSetScale( lines, 0.0, (double)((n > maxits)?n:maxits), 
		            minres, maxres );
    }
else 
    XBLinesAutoScale( lines );
if (x > 0) {
    XBLinesRescale( XBWin, lines );
    XBClearWindow( XBWin, 0, 0, XWinSave.w, XWinSave.h );
    XBASetLimits( Xad, 0.0, (double)((n > maxits)?n:maxits), 
		  lines->ymin<minres? lines->ymin : minres, lines->ymax );
    XSetForeground( XBWin->disp, XBWin->gc.set, XBWin->foreground );
    XBADrawAxis( Xad );
    XBLinesDraw( XBWin, lines );
    XBFlush( XBWin );
    }
}

/*@
    ITXMonitorLimits - Sets the limits for the residual monitor.

    Input Parameters:
.   maxit - maximum number of iterations
.   mres  - minimum residual value (NOT the log of the minimum residual)

    Note:
    Should these limits be exceeded, the graph limits will be automatically
    extended.  
    To use this routine, first call ITXMonitor( 0, 0, -2, 0.0 ); this will
    initialize the monitor.
@*/
void ITXMonitorLimits( maxit, mres )
int    maxit;
double mres;
{
maxits = maxit;
if (mres > 0)
    minres = log10( mres );
}


/*
   This is a version that displays the current residual as values on a mesh,
   with the mesh sizes defined in advance.
 */

static int MNX = 1, MNY = 1;
static double *mval = 0, *res;
static int which = 1;
/*
   In addition, the user may set the function used to extract the data
   to display.  This allows the user to select one component in a 
   multicomponent problem, or even a non-mesh grid if a routine is
   provided that can interpolate to a regular mesh.

   We also need an option to display ALL components simultaneously.
 */
static int NC = 1;                 /* Number of components to display */
static int NCCMP = 0;              /* Which component to display */
static int NCX = 1, NCY = 1;       /* Number to display in the x,y coordinate 
				      directions */
static void (*GetComponent)() = 0; /* Routine to extract a component */

/*@
  ITXMonitorMeshSize - Sets the mesh size for the display of 2-d contour
  plots in monitoring iter package performance.

  Input Parameters:
. nx,ny  - size of mesh in x and y directions
@*/
void ITXMonitorMeshSize( nx, ny )
int nx, ny;
{
MNX = nx;
MNY = ny;

if (mval) {
    FREE(mval);
    FREE(res);
    }
mval = (double *)MALLOC( nx * ny * sizeof(double) );   CHKPTR(mval);
res  = (double *)MALLOC( nx * ny * sizeof(double) );   CHKPTR(res);

}

/*@
  ITXMonitorMultiComponent - Informs ITXMonitor how to handle multicomponent
  problems.

  Input Parameters:
. nc - number of components to display (only 1 supported at this time)
. ncx,ncy - number of components in x and y direction (the display, for nc > 1,
  tiles the components into a larger window)
. extract - function to extract a given component into a mesh.
            The format of this function is
$           void extract( p, usrP, i )
$           void *p, *usrP;
$           int i;
$           where p points to the vector (solution or residual), usrP is
  the user pointer (passed to ITXMonitorRval), and i is the index of the
  component to display.  If extract is null, the entire vector is used.
  The routine ITXMonitorExtractDefault will extract components under
  the assumption that the components are numbered most rapidly.
. cmp - which component to display (starting from 0).  Only if nc == 1.
@*/
void ITXMonitorMultiComponent( nc, ncx, ncy, extract, cmp )
int nc, ncx, ncy, cmp;
void (*extract)();
{
NC           = nc;
NCX          = ncx;
NCY          = ncy;
GetComponent = extract;
NCCMP        = cmp;
}

/*ARGSUSED*/
void ITXMonitorExtractDefault( p, usrP, i )
void   *usrP;
double *p;
int i;
{
double *dest = p;
int    nc    = NC;
int    n     = MNX * MNY;

/* Move to first component */
p += i;

/* Copy every NC'th element */
while (n--) {
    *dest++ = *p;
    p       += nc;
    }
}

/*ARGSUSED*/
/*@
  ITXMonitorRVal - Simple X Windows code to display the value of the 
               residual at each iteration in the iterative solvers.

  Input Parameters:
. itP   - iterative context
. usrP  - user's context
. n     - iteration number.  If < 0, initialize the display
. rnorm - 2-norm residual value (may be estimated).  

  Note:
  The size of the mesh must be set with ITXMonitorMeshSize before calling
  this routine.
 @*/
void ITXMonitorRVal( itP, usrP, n, rnorm )
ITCntx *itP;
void   *usrP;
int    n;
double rnorm;
{
double *p;
int    i;

if (n < 0) {
    /* Setup call */
    if (!XBWin) {
	XBWin = XBQGetWindow( "Residual", "" );
	if (XBWin) XWinSave = *XBWin;
	}
    if (!XBWin) return;
    *XBWin = XWinSave;
    XBClearWindow( XBWin, 0, 0, XBWin->w, XBWin->h );
    if (n < -1) return;
    }
if (!XBWin) return;

/* Compute the residual */
mval = (double *)ITDefaultBuildSolution( itP, usrP, mval );
p    = mval;
if (which == 0) {
    (*itP->amult)( usrP, mval, res );
    (*itP->vc->axpy)( usrP, -1.0, itP->vec_rhs, res );
    p = res;
    }
/* Extract the selected components */
/* for (i = 0; i<NC; i++) { */
    i = NCCMP;
    if (GetComponent) {
	(*GetComponent)( mval, usrP, i );
	}
    /* For this to work, we really need to contour into subareas of the
       window */
    XBQContour( p, (double *)0, (double *)0, MNX, MNY, 32 );
/*     } */
XBFlush( XBWin );
}
