/*
 * USC_MAIN.H  (Private header file for the Microsecond Clock package)
 *
 * Written by:  Arun Nanda    (07/17/91)
 *
 * The following machine-specific libraries need to be linked in
 * with the application using the UST functions:
 *
 *      MULTIMAX      -lpp
 *      BALANCE       -lseq
 *      SYMMETRY      -lseq
 *
 * Modified by William Gropp (08/04/92)
 */


#include "system/time/usec.h"

#if defined(encore)

#    include <parallel.h>
#    define SYusc_MD_timer_size  (sizeof(unsigned)*8)
     unsigned *usc_multimax_timer;

#elif (defined(balance) || defined(symmetry))

#    define SYusc_MD_timer_size  (sizeof(usclk_t)*8)

#elif defined(intelnx) 

#    if (defined (DELTA))
#        include <mesh.h>
#    else
#        include <cube.h>
#    endif
#    define SYusc_MD_ticks_per_usec (HWHZ/1000000)
static double SY32toDBL = 0.0;

#elif defined(tc2000) 
static double SY32toDBL = 0.0;

#elif defined(USEGETTIMEOFDAY)
#	include <sys/time.h>

#elif defined(cm5)
#define CM5TOOLSTIMER 0
#include <cm/timers.h>

#endif





