#include <stdio.h>
#include "tools.h"
#include "system/time/usec.h"

double SYResolution_test(), VendorResolution_test();

main( argc, argv )
int  argc;
char **argv;
{
double *d, elp;
int    m = 10000;
FILE   *fp = stdout;
char   fname[1024];

if (SYArgHasName( &argc, argv, 1, "-help" )) {
    fprintf( stderr, "%s [-vendor]  [-dump] [-short] [-long] [-f name]" );
    return 0;
    }
SYusc_init();
if (SYArgGetString( &argc, argv, 1, "-f", fname, 1024 )) {
    fp = fopen( fname, "w" );
    if (!fp) return 1;
    }
    
fprintf(fp, "\n#Rollover Value = %lu\n", SYusc_rollover_val());

if (SYArgHasName( &argc, argv, 1, "-short" )) {
    printf("\n\nShort Loop Test:\n");
    printf("================\n\n");
    short_loop();
    }

if (SYArgHasName( &argc, argv, 1, "-long" )) {
    printf("\n\nLong Loop Test (measures 5 second intervals):\n");
    printf("=================================================\n");
    printf("(***** Type ^C to terminate this test *****)\n\n");
    Long_loop();
    }

printf( "\n\nResolution test\n" );
d   = (double *)MALLOC( (m + 1)* sizeof(double) );   CHKPTR(d);
if (SYArgHasName( &argc, argv, 1, "-vendor" )) 
    elp = VendorResolution_test( d, m );
else
    elp = SYResolution_test( d, m );

/* Analyze the results */
Analyze( fp, d, m, SYArgHasName( &argc, argv, 1, "-dump") );
}


short_loop()
{
	SYusc_time_t t1, t2, t3;
	SYusc_time_t t[100];
	double mind, maxd;
	double delta;
	int i;

	for (i=0; i<100; i++)
		SYusc_clock(t+i);
	mind = 1.0;
	maxd = 0.0;
	for (i=0; i<100; i++) {
		printf("Clock Reading %2d:  %lf\n", i+1, SYuscValue(t+i));
		if (i < 99) {
		    delta = SYuscDiff( t+i, t+i+1 );
		    if (delta > 0.0 && delta < mind) mind = delta;
		    if (delta > maxd) maxd = delta;
		    }
		}
	printf( "\nMin difference %le; Max difference %le\n", mind, maxd );

	printf("\nThree additional readings...just for the heck of it\n");
	SYusc_clock( &t1 );
	SYusc_clock( &t2 );
	SYusc_clock( &t3 );
	printf("time1 = %lf,  time2 = %lf,  time3 = %lf\n", 
	        SYuscValue(&t1), SYuscValue(&t2), SYuscValue(&t3));
}


Long_loop()
{
	SYusc_time_t t1, t2;
	int i,j;

	for(j=0;j < 10; j++)
	{
		SYusc_clock( &t1 );
		sleep(5);

		SYusc_clock( &t2 );
		printf("Start_time = %lf    End_time = %lf\n\n", 
		        SYuscValue(&t1), SYuscValue(&t2));
		printf("---> Interval = %lf seconds <---\n\n", 
		       SYuscDiff(&t1,&t2) );
	}
}

/* Resolution test.  Returns elapsed time */
double SYResolution_test( diff, m )
double *diff;
int    m;
{
SYusc_time_t *t, t1, t2;
int          i, mm = m + 1;

t = (SYusc_time_t *)MALLOC( (m + 1) * sizeof(SYusc_time_t) );  CHKPTRN(t);

SYusc_clock( &t1 );
for (i=0; i<mm; i++)
    SYusc_clock( t + i );
SYusc_clock( &t2 );

for (i=0; i<m; i++) 
    diff[i] = SYuscDiff( t + i, t + i + 1 );

return SYuscDiff( &t1, &t2 );
}

/* This is for eventual comparison against vendor-specific timers */
double VendorResolution_test( diff, m )
double *diff;
int    m;
{
#ifdef intelnx
double dclock(), t1, t2;
int    i, mm = m + 1;
t1 = dclock();
for (i=0; i<mm; i++)
    diff[i] = dclock();
t2 = dclock();

for (i=0; i<m; i++) 
    diff[i] = diff[i+1] - diff[i];

return t2 - t1;
#endif
}

Analyze( fp, d, m, flag )
FILE   *fp;
double *d;
int    m, flag;
{
double mean, mx, mn;
int    i;

mean = mx = mn = d[0];
for (i=1; i<m; i++) {
    mean += d[i];
    if (d[i] > mx)      mx = d[i];
    else if (d[i] < mn) mn = d[i];
    }
mean /= (double)m;
fprintf( fp, 
	 "# Resolution of clock:\n#mean = %e, max sep = %e, min sep = %e\n",
         mean, mx, mn );
if (flag) {
    /*  dump the resolution data */
    for (i=0; i<m; i++) 
	fprintf( fp, "%d %e\n", i, d[i] );
    }
}
