#ifndef lint
static char SCCSid[] = "@(#) ./sparse/transpos.c 07/23/93";
#endif

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"

/*@
  SpTranspose - Generate the transpose of a sparse matrix.

  Input Parameter:
. mat - matrix to form transpose of
 @*/
SpMat *SpTranspose( mat )
SpMat *mat;
{
SpMat  *new;
int    i, nz,*ix;
double *xv;

SPLITTOMAT(mat);

new = SpCreate( mat->cols, mat->rows, 0 ); CHKERRV(1,0);

/* This is a very simple algorithm: we just insert every element into the
   new sparse matrix */
for (i=0; i<mat->rows; i++) {
    SpScatterFromRow( mat, i, &nz, &ix, &xv );
    while (nz--) 
	SpAddValue( new, *xv++, *ix++, i ); CHKERRV(1,0);
    }

/* Now, if the matrix is Mapped, switch the mapping pointers */
if (mat->map) {
    SpCopyMappings( new, mat->map->colmap, mat->map->rowmap, 
		        (int *)0 ); CHKERRV(1,0); 
    mat->map->icolmap = 0;
    }
return new;
}

