/* 
   Quick fortran interface to SpWrite
 */

#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"

spnwrite_( name, nr, nz, ia, ja, a, d )
char   *name;
int    *nr, *nz, *ia, *ja, d;
double *a;
{
char fname[1024];
int  fd;

/* copy name with a null at the end */
strncpy( fname, name, d );
fname[d] = '\0';

/* open file */
fd = open( fname, O_RDWR | O_CREAT );
if (!fd) {
    fprintf( stderr, "Could not open file %s for writing\n", fname );
    exit(1);
    }

SpiWrite( fd, MATROW, *nr, *nr, *nz, ia, ja, a );
}

