C----- SUBROUTINE ROOTLS
C***************************************************************           1.
C***************************************************************           2.
C********     ROOTLS ..... ROOTED LEVEL STRUCTURE      *********           3.
C***************************************************************           4.
C***************************************************************           5.
C                                                                          6.
C     PURPOSE - ROOTLS GENERATES THE LEVEL STRUCTURE ROOTED                7.
C        AT THE INPUT NODE CALLED ROOT. ONLY THOSE NODES FOR               8.
C        WHICH MASK IS NONZERO WILL BE CONSIDERED.                         9.
C                                                                         10.
C     INPUT PARAMETERS -                                                  11.
C        ROOT - THE NODE AT WHICH THE LEVEL STRUCTURE IS TO               12.
C               BE ROOTED.                                                13.
C        (XADJ, ADJNCY) - ADJACENCY STRUCTURE PAIR FOR THE                14.
C               GIVEN GRAPH.                                              15.
C        MASK - IS USED TO SPECIFY A SECTION SUBGRAPH. NODES              16.
C               WITH MASK(I)=0 ARE IGNORED.                               17.
C                                                                         18.
C     OUTPUT PARAMETERS -                                                 19.
C        NLVL - IS THE NUMBER OF LEVELS IN THE LEVEL STRUCTURE.           20.
C        (XLS, LS) - ARRAY PAIR FOR THE ROOTED LEVEL STRUCTURE.           21.
C                                                                         22.
C***************************************************************          23.
C                                                                         24.
      SUBROUTINE  ROOTLS ( ROOT, XADJ, ADJNCY, MASK, NLVL, XLS, LS )      25.
C                                                                         26.
C***************************************************************          27.
C                                                                         28.
         INTEGER ADJNCY(1), LS(1), MASK(1), XLS(1)                        29.
         INTEGER XADJ(1), I, J, JSTOP, JSTRT, LBEGIN,                     30.
     1           CCSIZE, LVLEND, LVSIZE, NBR, NLVL,                       31.
     1           NODE, ROOT                                               32.
C                                                                         33.
C***************************************************************          34.
C                                                                         35.
C        ------------------                                               36.
C        INITIALIZATION ...                                               37.
C        ------------------                                               38.
         MASK(ROOT) = 0                                                   39.
         LS(1) = ROOT                                                     40.
         NLVL = 0                                                         41.
         LVLEND = 0                                                       42.
         CCSIZE = 1                                                       43.
C        -----------------------------------------------------            44.
C        LBEGIN IS THE POINTER TO THE BEGINNING OF THE CURRENT            45.
C        LEVEL, AND LVLEND POINTS TO THE END OF THIS LEVEL.               46.
C        -----------------------------------------------------            47.
  200    LBEGIN = LVLEND + 1                                              48.
         LVLEND = CCSIZE                                                  49.
         NLVL = NLVL + 1                                                  50.
         XLS(NLVL) = LBEGIN                                               51.
C        -------------------------------------------------                52.
C        GENERATE THE NEXT LEVEL BY FINDING ALL THE MASKED                53.
C        NEIGHBORS OF NODES IN THE CURRENT LEVEL.                         54.
C        -------------------------------------------------                55.
         DO 400 I = LBEGIN, LVLEND                                        56.
            NODE = LS(I)                                                  57.
            JSTRT = XADJ(NODE)                                            58.
            JSTOP = XADJ(NODE + 1) - 1                                    59.
            IF ( JSTOP .LT. JSTRT )  GO TO 400                            60.
               DO 300 J = JSTRT, JSTOP                                    61.
                  NBR = ADJNCY(J)                                         62.
                  IF (MASK(NBR) .EQ. 0) GO TO 300                         63.
                     CCSIZE = CCSIZE + 1                                  64.
                     LS(CCSIZE) = NBR                                     65.
                     MASK(NBR) = 0                                        66.
  300          CONTINUE                                                   67.
  400    CONTINUE                                                         68.
C        ------------------------------------------                       69.
C        COMPUTE THE CURRENT LEVEL WIDTH.                                 70.
C        IF IT IS NONZERO, GENERATE THE NEXT LEVEL.                       71.
C        ------------------------------------------                       72.
         LVSIZE = CCSIZE - LVLEND                                         73.
         IF (LVSIZE .GT. 0 ) GO TO 200                                    74.
C        -------------------------------------------------------          75.
C        RESET MASK TO ONE FOR THE NODES IN THE LEVEL STRUCTURE.          76.
C        -------------------------------------------------------          77.
         XLS(NLVL+1) = LVLEND + 1                                         78.
         DO 500 I = 1, CCSIZE                                             79.
            NODE = LS(I)                                                  80.
            MASK(NODE) = 1                                                81.
  500    CONTINUE                                                         82.
         RETURN                                                           83.
      END                                                                 84.
