C----- SUBROUTINE QMDUPD
C****************************************************************          1.
C****************************************************************          2.
C**********     QMDUPD ..... QUOT MIN DEG UPDATE      ***********          3.
C****************************************************************          4.
C****************************************************************          5.
C                                                                          6.
C     PURPOSE - THIS ROUTINE PERFORMS DEGREE UPDATE FOR A SET              7.
C        OF NODES IN THE MINIMUM DEGREE ALGORITHM.                         8.
C                                                                          9.
C     INPUT PARAMETERS -                                                  10.
C        (XADJ, ADJNCY) - THE ADJACENCY STRUCTURE.                        11.
C        (NLIST, LIST) - THE LIST OF NODES WHOSE DEGREE HAS TO            12.
C               BE UPDATED.                                               13.
C                                                                         14.
C     UPDATED PARAMETERS -                                                15.
C        DEG - THE DEGREE VECTOR.                                         16.
C        QSIZE - SIZE OF INDISTINGUISHABLE SUPERNODES.                    17.
C        QLINK - LINKED LIST FOR INDISTINGUISHABLE NODES.                 18.
C        MARKER - USED TO MARK THOSE NODES IN REACH/NBRHD SETS.           19.
C                                                                         20.
C     WORKING PARAMETERS -                                                21.
C        RCHSET - THE REACHABLE SET.                                      22.
C        NBRHD -  THE NEIGHBORHOOD SET.                                   23.
C                                                                         24.
C     PROGRAM SUBROUTINES -                                               25.
C        QMDMRG.                                                          26.
C                                                                         27.
C****************************************************************         28.
C                                                                         29.
      SUBROUTINE  QMDUPD ( XADJ, ADJNCY, NLIST, LIST, DEG,                30.
     1                     QSIZE, QLINK, MARKER, RCHSET, NBRHD )          31.
C                                                                         32.
C****************************************************************         33.
C                                                                         34.
         INTEGER  ADJNCY(1), LIST(1), DEG(1), MARKER(1),                  35.
     1            RCHSET(1), NBRHD(1), QSIZE(1), QLINK(1)                 36.
         INTEGER  XADJ(1), DEG0, DEG1, IL, INHD, INODE, IRCH,             37.
     1            J, JSTRT, JSTOP, MARK, NABOR, NHDSZE, NLIST,            38.
     1            NODE, RCHSZE
C                                                                         40.
C****************************************************************         41.
C                                                                         42.
C        ------------------------------------------------                 43.
C        FIND ALL ELIMINATED SUPERNODES THAT ARE ADJACENT                 44.
C        TO SOME NODES IN THE GIVEN LIST. PUT THEM INTO                   45.
C        (NHDSZE, NBRHD). DEG0 CONTAINS THE NUMBER OF                     46.
C        NODES IN THE LIST.                                               47.
C        ------------------------------------------------                 48.
         IF ( NLIST .LE. 0 )  RETURN                                      49.
         DEG0 = 0                                                         50.
         NHDSZE = 0                                                       51.
         DO 200 IL = 1, NLIST                                             52.
            NODE = LIST(IL)                                               53.
            DEG0 = DEG0 + QSIZE(NODE)                                     54.
            JSTRT = XADJ(NODE)                                            55.
            JSTOP = XADJ(NODE+1) - 1                                      56.
            DO 100 J = JSTRT, JSTOP                                       57.
               NABOR = ADJNCY(J)                                          58.
               IF ( MARKER(NABOR) .NE. 0  .OR.                            59.
     1              DEG(NABOR) .GE. 0 )  GO TO 100                        60.
                  MARKER(NABOR) = - 1                                     61.
                  NHDSZE = NHDSZE + 1                                     62.
                  NBRHD(NHDSZE) = NABOR                                   63.
  100       CONTINUE                                                      64.
  200    CONTINUE                                                         65.
C        --------------------------------------------                     66.
C        MERGE INDISTINGUISHABLE NODES IN THE LIST BY                     67.
C        CALLING THE SUBROUTINE QMDMRG.                                   68.
C        --------------------------------------------                     69.
         IF ( NHDSZE .GT. 0 )                                             70.
     1      CALL  QMDMRG ( XADJ, ADJNCY, DEG, QSIZE, QLINK,               71.
     1                     MARKER, DEG0, NHDSZE, NBRHD, RCHSET,           72.
     1                     NBRHD(NHDSZE+1) )                              73.
C        ----------------------------------------------------             74.
C        FIND THE NEW DEGREES OF THE NODES THAT HAVE NOT BEEN             75.
C        MERGED.                                                          76.
C        ----------------------------------------------------             77.
         DO 600 IL = 1, NLIST                                             78.
            NODE = LIST(IL)                                               79.
            MARK = MARKER(NODE)                                           80.
            IF ( MARK .GT. 1  .OR.  MARK .LT. 0 )  GO TO 600              81.
               MARKER(NODE) = 2                                           82.
               CALL  QMDRCH ( NODE, XADJ, ADJNCY, DEG, MARKER,            83.
     1                        RCHSZE, RCHSET, NHDSZE, NBRHD )             84.
               DEG1 = DEG0                                                85.
               IF ( RCHSZE .LE. 0 )  GO TO 400                            86.
                  DO 300 IRCH = 1, RCHSZE                                 87.
                     INODE = RCHSET(IRCH)                                 88.
                     DEG1 = DEG1 + QSIZE(INODE)                           89.
                     MARKER(INODE) = 0                                    90.
  300             CONTINUE                                                91.
  400          DEG(NODE) = DEG1 - 1                                       92.
               IF ( NHDSZE .LE. 0 )  GO TO 600                            93.
                  DO 500 INHD = 1, NHDSZE                                 94.
                     INODE = NBRHD(INHD)                                  95.
                     MARKER(INODE) = 0                                    96.
  500             CONTINUE                                                97.
  600    CONTINUE                                                         98.
         RETURN                                                           99.
      END                                                                100.
