C----- SUBROUTINE QMDMRG
C****************************************************************          1.
C****************************************************************          2.
C**********     QMDMRG ..... QUOT MIN DEG MERGE       ***********          3.
C****************************************************************          4.
C****************************************************************          5.
C                                                                          6.
C     PURPOSE - THIS ROUTINE MERGES INDISTINGUISHABLE NODES IN             7.
C               THE MINIMUM DEGREE ORDERING ALGORITHM.                     8.
C               IT ALSO COMPUTES THE NEW DEGREES OF THESE                  9.
C               NEW SUPERNODES.                                           10.
C                                                                         11.
C     INPUT PARAMETERS -                                                  12.
C        (XADJ, ADJNCY) - THE ADJACENCY STRUCTURE.                        13.
C        DEG0 - THE NUMBER OF NODES IN THE GIVEN SET.                     14.
C        (NHDSZE, NBRHD) - THE SET OF ELIMINATED SUPERNODES               15.
C               ADJACENT TO SOME NODES IN THE SET.                        16.
C                                                                         17.
C     UPDATED PARAMETERS -                                                18.
C        DEG - THE DEGREE VECTOR.                                         19.
C        QSIZE - SIZE OF INDISTINGUISHABLE NODES.                         20.
C        QLINK - LINKED LIST FOR INDISTINGUISHABLE NODES.                 21.
C        MARKER - THE GIVEN SET IS GIVEN BY THOSE NODES WITH              22.
C               MARKER VALUE SET TO 1.  THOSE NODES WITH DEGREE           23.
C               UPDATED WILL HAVE MARKER VALUE SET TO 2.                  24.
C                                                                         25.
C     WORKING PARAMETERS -                                                26.
C        RCHSET - THE REACHABLE SET.                                      27.
C        OVRLP -  TEMP VECTOR TO STORE THE INTERSECTION OF TWO            28.
C               REACHABLE SETS.                                           29.
C                                                                         30.
C****************************************************************         31.
C                                                                         32.
      SUBROUTINE  QMDMRG ( XADJ, ADJNCY, DEG, QSIZE, QLINK,               33.
     1                     MARKER, DEG0, NHDSZE, NBRHD, RCHSET,           34.
     1                     OVRLP )                                        35.
C                                                                         36.
C****************************************************************         37.
C                                                                         38.
         INTEGER  ADJNCY(1), DEG(1), QSIZE(1), QLINK(1),                  39.
     1            MARKER(1), RCHSET(1), NBRHD(1), OVRLP(1)                40.
         INTEGER  XADJ(1), DEG0, DEG1, HEAD, INHD, IOV, IRCH,             41.
     1            J, JSTRT, JSTOP, LINK, LNODE, MARK, MRGSZE,             42.
     1            NABOR, NHDSZE, NODE, NOVRLP, RCHSZE, ROOT               43.
C                                                                         44.
C****************************************************************         45.
C                                                                         46.
C        ------------------                                               47.
C        INITIALIZATION ...                                               48.
C        ------------------                                               49.
         IF ( NHDSZE .LE. 0 )  RETURN                                     50.
         DO 100 INHD = 1, NHDSZE                                          51.
            ROOT = NBRHD(INHD)                                            52.
            MARKER(ROOT) = 0                                              53.
  100    CONTINUE                                                         54.
C        -------------------------------------------------                55.
C        LOOP THROUGH EACH ELIMINATED SUPERNODE IN THE SET                56.
C        (NHDSZE, NBRHD).                                                 57.
C        -------------------------------------------------                58.
         DO 1400 INHD = 1, NHDSZE                                         59.
            ROOT = NBRHD(INHD)                                            60.
            MARKER(ROOT) = - 1                                            61.
            RCHSZE = 0                                                    62.
            NOVRLP = 0                                                    63.
            DEG1   = 0                                                    64.
  200       JSTRT  = XADJ(ROOT)                                           65.
            JSTOP  = XADJ(ROOT+1) - 1                                     66.
C           ----------------------------------------------                67.
C           DETERMINE THE REACHABLE SET AND ITS INTERSECT-                68.
C           ION WITH THE INPUT REACHABLE SET.                             69.
C           ----------------------------------------------                70.
            DO 600 J = JSTRT, JSTOP                                       71.
               NABOR = ADJNCY(J)                                          72.
               ROOT  = - NABOR                                            73.
               IF (NABOR)  200, 700, 300                                  74.
C                                                                         75.
  300          MARK = MARKER(NABOR)                                       76.
               IF ( MARK ) 600, 400, 500                                  77.
  400             RCHSZE = RCHSZE + 1                                     78.
                  RCHSET(RCHSZE) = NABOR                                  79.
                  DEG1 = DEG1 + QSIZE(NABOR)                              80.
                  MARKER(NABOR) = 1                                       81.
                  GOTO 600                                                82.
  500          IF ( MARK .GT. 1 )  GOTO 600                               83.
                  NOVRLP = NOVRLP + 1                                     84.
                  OVRLP(NOVRLP) = NABOR                                   85.
                  MARKER(NABOR) = 2                                       86.
  600       CONTINUE                                                      87.
C           --------------------------------------------                  88.
C           FROM THE OVERLAPPED SET, DETERMINE THE NODES                  89.
C           THAT CAN BE MERGED TOGETHER.                                  90.
C           --------------------------------------------                  91.
  700       HEAD = 0                                                      92.
            MRGSZE = 0                                                    93.
            DO 1100 IOV = 1, NOVRLP                                       94.
               NODE = OVRLP(IOV)                                          95.
               JSTRT = XADJ(NODE)                                         96.
               JSTOP = XADJ(NODE+1) - 1                                   97.
               DO 800 J = JSTRT, JSTOP                                    98.
                  NABOR = ADJNCY(J)                                       99.
                  IF ( MARKER(NABOR) .NE. 0 )  GOTO 800                  100.
                     MARKER(NODE) = 1                                    101.
                     GOTO 1100                                           102.
  800          CONTINUE                                                  103.
C              -----------------------------------------                 104.
C              NODE BELONGS TO THE NEW MERGED SUPERNODE.                 105.
C              UPDATE THE VECTORS QLINK AND QSIZE.                       106.
C              -----------------------------------------                 107.
               MRGSZE = MRGSZE + QSIZE(NODE)                             108.
               MARKER(NODE) = - 1                                        109.
               LNODE = NODE                                              110.
  900          LINK  = QLINK(LNODE)                                      111.
               IF ( LINK .LE. 0 )  GOTO 1000                             112.
                  LNODE = LINK                                           113.
                  GOTO 900                                               114.
 1000          QLINK(LNODE) = HEAD                                       115.
               HEAD = NODE                                               116.
 1100       CONTINUE                                                     117.
            IF ( HEAD .LE. 0 )  GOTO 1200                                118.
               QSIZE(HEAD) = MRGSZE                                      119.
               DEG(HEAD) = DEG0 + DEG1 - 1                               120.
               MARKER(HEAD) = 2                                          121.
C           --------------------                                         122.
C           RESET MARKER VALUES.                                         123.
C           --------------------                                         124.
 1200       ROOT = NBRHD(INHD)                                           125.
            MARKER(ROOT) = 0                                             126.
            IF ( RCHSZE .LE. 0 )  GOTO 1400                              127.
               DO 1300 IRCH = 1, RCHSZE                                  128.
                  NODE = RCHSET(IRCH)                                    129.
                  MARKER(NODE) = 0                                       130.
 1300          CONTINUE                                                  131.
 1400    CONTINUE                                                        132.
         RETURN                                                          133.
      END                                                                134.
