#ifndef LINT
static char SCCSid[] = "@(#) ./sparse/default/sample.c 07/23/93";
#endif

/*
    Allocate SparseMatrices and Factors
 */
#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"

extern void SpRSolve(), SpRSolveTrans();
extern int  SpRComputeFill(), SpRComputeFactor();
void        SpRScatterFromRow(), SpRGatherToRow(), SpRGatherAddToRow();
void        SpRDestroy();
SpMat       *SpRCreate();

/*@
   SpRCreate -Allocate an n x m sparse matrix (row format).

   Input Parameters:
.   n - number of rows
.   m - number of columns
.   mmax - estimated number of elements in each row (this many elements
          will be pre-allocated; this value may be set to zero, in which
	  case space will be allocated as required.)
 @*/
SpMat *SpRCreate( n, m, mmax )
int  n, m, mmax;
{
SpMat *mat;
SpRowMat *R;
SpVec *vs, **nb;
int   i;

TRPUSH(SPTRID + TRIDCREATE);

mat              = NEW(SpMat); CHKPTRV(mat,0);
R                = NEW(SpRowMat); CHKPTRV(R,0);
mat->data = (void *)R;
nb               = (SpVec **) MALLOC( n*(sizeof(SpVec *) +
					  sizeof(SpVec)) ); CHKPTRV(nb,0);
SPiInitPool( &mat->pool ); CHKERRV(0,0);
R->rs          = nb;
R->blks        = 0;
R->rblks       = 0;

mat->rows           = n;
mat->cols           = m;
mat->nz             = 0;
mat->alloc_incr     = 5;
mat->alloc_together = 1;
mat->element_length = sizeof(double);
mat->is_sorted      = 1;                /* This means that the columns
					   are in sorted order */
mat->map            = 0;
mat->type           = MATROW;
vs = (SpVec *) (R->rs + n);
for (i=0; i<n; i++) {
    R->rs[i] = vs;
    vs->maxn   = mmax;
    vs->nz     = 0;
    vs->blki   = -1;
    vs->rblki  = -1;
    vs->dloc   = -1;
    /* allocate from chunck */
    if (mmax > 0) {
	SPMallocNV( mat, mmax, &vs->v, &vs->i ); CHKERRV(0,0);
	}
    else {
	vs->v = 0;
	vs->i = 0;
	}
    vs++;
    }
mat->ops = &_SpRowOps;
TRPOP;
return mat;
}

/*
  SpRDestroy - Free a sparse matrix (row format).
 */
void SpRDestroy( mat )
SpMat *mat;
{
SpiPoolFree( &mat->pool );
if (mat->map) SpDestroyMap( mat->map );
SpDestroyBlk( (SpRowMat *)mat->data );
SPFree( ((SpRowMat *)mat->data)->rs );
SPFree( mat->data );
SPFree( mat );
}

/*@
   SpCreateSplit - Allocate an n x m sparse matrix factor.

   Input Parameters:
.   model - model matrix
.   mmax - estimated number of elements in each row (this many elements
          will be pre-allocated; this value may be set to zero, in which
	  case space will be allocated as required.)
 @*/
SpMatSplit *SpDfCreateSplit( model, mmax )
SpMat *model;
int   mmax;
{
SpMatSplit *mat;

TRPUSH(SPTRID + TRIDCREATE + 1);
mat         = NEW(SpMatSplit);  CHKPTRV(mat,0);
mat->type   = MATSPLIT;
mat->factor = SpDfCreate( model->rows, model->cols ); CHKERRV(0,0);
mat->nzl    = (int *) MALLOC( n*sizeof(int) ); CHKPTRV(mat->nzl,0);
TRPOP;
return mat;
}

/*@
  SpDestroySplit - Free a sparse matrix factor.
 @*/
void SpDestroySplit( mat )
SpMatSplit *mat;
{
SpDestroy( mat->factor );
SPFree( mat->nzl );
SPFree( mat );
}

/*
   These routines manage the space for a SpMat.
   Space is allocated in large chuncks and then parceled out by this
   routine.  The corresponding free routine 
 */
void SPMallocNV( mat, n, v, i )
SpMat *mat;
double       **v;
int          n, **i;
{
SPiPoolAllocNV( &mat->pool, n, v, i );
}

/* Free a sparse row's data, given the matrix that it came from */
SPFreeNV(mat,n,v,i)
SpMat *mat;
double       *v;
int          n, *i;
{
SPiPoolFreeNV( &mat->pool, n, v, i );
}

/*@
  SpExtend - Add additional rows and/or columns to a matrix. 

  Input parameters:
. mat  - matrix to extend
. nrows- number of rows in modifed matrix
. ncols- number of columns in modified matrix

  Note:
  Currently, increases in ROW size are not supported.
 @*/
void SpExtend( mat, nrows, ncols )
SpMat *mat;
int   nrows, ncols;
{
if (nrows <= mat->rows) {
    mat->rows = nrows;
    mat->cols = ncols;
    return;
    }
SETERRC(-1,"Could not extend matrix (row extension not supported)");
}

/*
   Here are routines to set various storage parameters.  Note that some
   of these can NOT be changed once any storage has been allocated.
   Things to provide are: chunck_size, MAT_INCR .

 */
/*@
    SpSetChunck - Set the allocation chunck size for the matrix.  If
    any storage has been allocated for matrix elements, this routine
    has no effect.

    Input Parameters:
.   mat    - matrix to set the chunck size for
.   chunck - chunck size to use
@*/ 
void SpSetChunck( mat, chunck )
SpMat *mat;
int   chunck;
{
}

/*@
    SpSetMatIncr - Set the amount of storage that is allocated when a
                   row is expanded.  This routine may have no effect.

    Input Parameters:
.   mat  - matrix to set the increment size for
.   incr - increment size to use
@*/                   
void SpSetMatIncr( mat, incr )
SpMat *mat;
int   incr;
{
mat->alloc_incr = incr;
}	


void SpRScatterFromRow( mat, row, nz, i, v )
SpMat  *mat;
int    row, *nz, **i;
double **v;
{
SpRowMat *R = (SpRowMat *)mat->data;
SpVec    *vs;

if (row < 0 || row >= mat->rows) {
    *nz = 0;
    return;
    }
vs  = R->rs[row];
if (nz)
    *nz = vs->nz;
if (i)
    *i  = vs->i;
if (v)
    *v  = vs->v;
}

void SpRGatherToRow( mat, row, nz, i, v )
SpMat  *mat;
int    nz, *i, row;
double *v;
{
SpSetInRow( mat, row, nz, v, i );    
}

void SpRGatherAddToRow( mat, row, nz, i, v )
SpMat  *mat;
int    nz, *i, row;
double *v;
{
SpAddInRow( mat, row, nz, v, i );    
}
