#ifndef lint
static char SCCSid[] = "@(#) ./solvers/iccd.c 07/23/93";
#endif

/*
        These are some of the routines for the incomplete Choleski
    preconditioner.
*/
#include "solvers/svctx.h"
#include "solvers/svpriv.h"
#include <math.h>

/*------------------------------------------------------------------*/
int SViSolveICC(ctx,b,x)
SVctx   *ctx;
double  *b,*x;
{
  int      its;
  double   t1;
  if (!ctx->setupcalled) (*ctx->setup)(ctx); CHKERRV(1,-1);
  if (!ctx->solvecalled) {
      t1   = SYGetCPUTime();
      ITSetUp(ctx->itctx,(void *) ctx); CHKERRV(1,-1);
      ctx->t_setup += SYGetCPUTime() - t1;
      }
  ctx->solvecalled = 1;

  t1 = SYGetCPUTime();
  SViManageInitialGuess( ctx, x );
  ctx->itctx->vec_rhs = (void *) b;
  ctx->itctx->vec_sol = (void *) x;
  its = ITSolve(ctx->itctx,(void *) ctx);
  SVGetITFlops(ctx,2*ctx->nz,2*ctx->nz + 2*ctx->size);
  ctx->its = its;
  ctx->t_solve += SYGetCPUTime() - t1;
  return its;
}
/*------------------------------------------------------------------*/
void SViDestroyICC(ctx)
SVctx *ctx;
{
  SVICCctx *lctx = (SVICCctx *) ctx->private;
  
  VEDestroy(ctx->itctx->vc);
  ITDestroy(ctx->itctx,ctx);
  FREE(lctx->diag);
  SpDestroySplit(lctx->split); FREE(ctx->private); FREE(ctx);
}
/*------------------------------------------------------------------*/
/*
   SViApplyICC - Applies the ICC precontioner to a dense vector, the matrix
   is hidden in the SVctx. 
 */

void SViApplyICCPreconditioner(ctx,x,y)
SVctx  *ctx;
double *x,*y;
{
  SVICCctx *lctx = (SVICCctx *) ctx->private;
  double   *d = lctx->diag;
  int      i,n = ctx->size;
  
  ctx->nbinv++;

  /* apply diagonal scaling to vector */
  for ( i=0; i<n; i++) y[i] = d[i]*x[i];

  SpiSolveSymmetric(lctx->split,y,y); CHKERR(1);

  /* apply diagonal scaling to vector */
  for ( i=0; i<n; i++) y[i] *= d[i];
}
