#ifndef lint
static char SCCSid[] = "@(#) ./nonlin/nlcreate.c 07/23/93";
#endif

#include "tools.h"
#include "nonlin/nlall.h"
#include "system/nreg.h"
#include <stdio.h>

static NRList *__NLList = 0;
/* -------------------------------------------------------------*/
/*@
  NLCreate - Builds NLCntx for a particular nonlinear solver.

   The NL library is a package for the solution of nonlinear
  systems of equations. They will include Newton type methods
  and possibly others.

   For the Newton type method the user must provide three routines,
  the first and third of which are optional.

. StepSetUp(nlcntx,usrcntx,x) 
. StepCompute(nlcntx,usrcntx,x,f,y,fnorm,ymax,rtol,gpnorm,ynorm)
. StepDestroy(nlcntx,usrcntx)
.  void *x - location for Jacobian
.  void *f - function at that point
.  void *y - location for resulting step
.  double fnorm - 2 norm of f squared
.  double ymax  - maximum two norm of step allowed
.  double rtol - tolerance in residual of linear system wanted
.  double *gpnorm - 2 norm of residual squared
.  double *ynorm - 2 norm of step squared.

  Input Parameter:
.  nlmethod   - One of the known methods.  See "nonlin/nlctx.h" for
    available methods. For instance NLNEWTONTR or NLNEWTONLS.
 @*/
NLCntx *NLCreate(nlmethod)
NLMETHOD nlmethod;
{
   NLCntx       *nlP;
   NLCntx       *(*r)();

  /* Get the function pointers for the iterative method requested */
  if (!__NLList) {NLRegisterAll();}
  if (!__NLList) {SETERR(1); return 0;}
  r = (NLCntx *(*)())NRFindRoutine( __NLList, (int)nlmethod, (char *)0 );
  if (!r) {SETERRC(1,"Unknown NL method"); return 0;}

  nlP = (*r)();
  return(nlP);        
}
/*----------------------------------------------------------------*/
/*@
   NLRegister - Given a iterative name (NLMETHOD) and a function pointer;
 adds the iterative method to the nonlinear solver package. 

   Input Parameters:
.      name - for instance NLNEWTONLS, ...
.      sname -  corresponding string for name
.      create - routine to create method context

@*/
void NLRegister(name, sname, create)
int     name;
char    *sname;
NLCntx  *(*create)();
{
if (!__NLList) __NLList = NRCreate();
NRRegister( __NLList, name, sname, (void (*)())create );
}
/*----------------------------------------------------------------*/
/*@
   NLRegisterDestroy - Frees the list of nonlinear solvers
  which have been registered by NLRegister().
@*/
void NLRegisterDestroy()
{
if (__NLList) {
    NRDestroy( __NLList );
    __NLList = 0;
    }
}


void NLSetDefaults( nlP )
NLCntx *nlP;
{
  nlP->vc                = 0;
  nlP->residual_history  = 0;
  nlP->max_it            = 50;
  nlP->max_func          = 1000;
  nlP->fp                = 0;
  nlP->ftol              = 1.e-8;
  nlP->xtol              = 1.e-8;
  nlP->trunctol          = 1.e-6;

  nlP->stepSetup         = 0;
  nlP->stepCompute       = 0;
  nlP->stepDestroy       = 0;
  nlP->stepCtx           = 0;
  nlP->initial_guess     = 0;

  nlP->nfunc             = 0;
  nlP->nvectors          = 0;
  nlP->nscalar           = 0;
  nlP->nsteps            = 0;

  nlP->converged         = NLDefaultConverged;
  nlP->usr_monitor       = NLDefaultMonitor;
}

/*@
  NLGetMethod - given the argument list, return the selected method

  Input parameters:
. Argc - pointer to arg count
. argv - argument vector
. sname - name used to indicate solver.  If null, -nlmethod is used

  Output parameter:
. nlmethod -  Solver method type
@*/
void NLGetMethod( Argc, argv, sname, nlmethod )
int      *Argc;
char     **argv, *sname;
NLMETHOD *nlmethod;
{
char sbuf[50];

if (!sname) sname = "-nlmethod";
if (SYArgGetString( Argc, argv, 1, sname, sbuf, 50 )) {
    if (!__NLList)
	NLRegisterAll();
    *nlmethod = (NLMETHOD)NRFindID( __NLList, sbuf );
    }
}

