#ifndef lint
static char SCCSid[] = "@(#) ./iter/preonly/preonly.c 07/23/93";
#endif

/*                       
       This implements a stub method that applies ONLY the preconditioner.
       This may be used in inner iterations, where it is desired to 
       allow multiple iterations as well as the "0-iteration" case
       
*/
#include <stdio.h>
#include <math.h>
#include "tools.h"
#include "iter/itctx.h"
#include "iter/itfunc.h"
#include "iter/itpriv.h"

/*+
ITPREONLYCreate - Creates an ITCntx variable for the applying only the 
preconditioner
The prefered calling sequence is ITCreate(ITPREONLY);
+*/
ITCntx *ITPREONLYCreate()
{
ITCntx    *itP;

itP = NEW(ITCntx);  CHKPTRV(itP,0);
ITSetDefaults( itP );
itP->MethodPrivate = (void *) 0;

itP->method               = ITPREONLY;
itP->usr_monitor          = ITDefaultMonitor;
itP->residual_history     = NULL;

itP->setup                = ITPREONLYSetUp;
itP->solver               = ITPREONLYSolve;
itP->adjustwork           = ITDefaultAdjustWork;
itP->closedown            = ITDefaultDestroy;
return(itP);
}

/*+
ITPREONLYSetUp - Called after a call to ITPREONLYCreate() or 
                 ITCREATE(ITPREONLY)
allocates space needed in the conjugate gradient solution. Preferred
calling sequence is ITSetUp(itP,usrP).

Input Parameters: 
.   itP - the iterative context
.   usrP - the user context
+*/
void ITPREONLYSetUp(itP,usrP)
ITCntx *itP;
void   *usrP;
{
if (itP->method != ITPREONLY) {
   SETERRC(1,"Attempt to use PREONLY Setup on wrong context"); return;}

/* check user parameters and functions */
if (ITCheckDef( itP )) return;
}

/*+
ITPREONLYSolve - Called after a call to ITPREONLYCreate() or 
                 ITCreate(ITPREONLY)
and the call to ITPREONLYSetUp() or ITSetUp().
Actually only applies the preconditioner ONCE to the right-hand-side.
If more iterations are desired, chose one of the iterative accelerators
(such as ITBCGS or ITRICHARDSON).  Prefered calling sequence ITSolve(itP,usrP).

Input Parameters: 
.   itP  - the iterative context
.   usrP - the user context

Returns:
the number of iterations required or -1 on error.
+*/
int  ITPREONLYSolve(itP, usrP)
void   *usrP;
ITCntx *itP;
{
void      *X,*B;
int       i = 0;

X       = itP->vec_sol;
B       = itP->vec_rhs;
PRE(B,X);

/* Get floating point work */
itP->nmatop   += 1;
itP->nvectors += 0;

return(1);
}

