C
C   This is a test program for the gmres solver.  We use the basic "vector"
C   ops in vectors.  This is a Fortran version of example2.
C
      program main
      integer itP, gmres_k, n, np
      double precision soln(1000), rhs(1000)
      integer VECreateDefaultUsrCntx, CvtToVoid
      external amult, binv
      include '../../solvers/svfort.h'
C
      gmres_k = 20
      n       = 100
      np      = VECreateDefaultUsrCntx( n )
      itP     = ITCreate(ITGMRES)
      call ITGMRESSetDirections( itP, gmres_k )
      call DVSetDefaultFunctions( ITVectorCtx( itP ) )
C
      n       = 100
C     Setup the user's private data structures 
      call ITSetRhs( itP, rhs )
      call ITSetSolution( itP, soln )
C
      call ITSetAmult(itP,amult)
      call ITSetBinv(itP,binv)
C
      call ITSetUp(itP,CvtToVoid(np))

C     set the rhs and the initial solution 
      call DVset( np, 1.0d0, rhs )
      call DVset( np, 0.0d0, soln )
C
      call ITSolve(itP,CvtToVoid(np))
      call ITDestroy(itP,CvtToVoid(np))
      stop 
      end
C
C     PrintResidual is currently unused...
      Subroutine PrintResidual( itP, np, soln, rhs, v1, v2 )
      integer itP
      integer np
      double precision  soln, rhs, v1, v2
C
      double precision res, dot
      integer n
C
      n  = np
C
C     Check on ACTUAL residual
      call amult( np, soln, v1 )
      call DVcopy( np, rhs, v1 )
      call DVaxpy( np, -1.0d0, v1, v2 )
      call DVdot(  np, v2, v2, dot )
      res   = sqrt( dot  )
      print *, 'Actual residual is ', res
      return
      end
C
C     Discrete laplacian
      subroutine amult( np, v1, v2 )
      integer np
      double precision v1(*), v2(*)
      integer i
C
      v2(1) = 2.0 * v1(1) - v1(2)
      do 10 i=2,np-1
 10      v2(i) = 2.0 * v1(i) - v1(i-1) - v1(i+1)
      v2(np) = 2.0 * v1(np) - v1(np-1)
      return
      end
C
      Subroutine binv( np, v1, v2 )
      integer np
      double precision v1(*), v2(*)
      integer i
C
      do 10 i=1, np
 10      v2(i) = v1(i)
      return
      end

