#ifndef lint
static char SCCSid[] = "@(#) ./comm/pcnt.c 07/23/93";
#endif

#include <stdio.h>
#include "tools.h"
#include "comm/comm.h"

/*
   This file contains routines for helping to manage the communication
   of an unknown amount of data with an unknown number of partners.
   It is assumed that each processor can compute how much data it is
   sending and to whom it is being sent.

   These routines then tell each routine the size of the largest message
   that they will receive, and the number of messages that they will
   receive.

   This is done by simply doing a global sum/max with the appropriate
   data.  This approach is often at least as fast as a reliable 
   termination criteria.  The ability to get the maximum message
   length often makes programs more robust.
 */

/*@
    PIGetNumPartners - Given an array of processor ids to SEND to, return the 
                       number of processors to RECEIVE from.

    Input Parameters:
.   pidx - array of processor ids
.   n    - number of elements in pidx
.   procset - processor subset	     
@*/
int PIGetNumPartners( pidx, n, procset )
int     *pidx, n;
ProcSet *procset;
{
int cnt, *nbrs, i;
int np, me;

np = PInumtids;
me = PImytid;

nbrs = (int *)MALLOC( 2 * np * sizeof(int) );     CHKPTRN(nbrs);
for (i=0; i<np; i++) nbrs[i] = 0;
for (i=0; i<n; i++) {
#ifdef DEBUG_ALL
    if (pidx[i] >= np || pidx[i] < 0) {
	fprintf( stderr, 
     "[%d] Invalid processor id (pidx[%d]=%d) in PIGetNumPartners\n",
		PImytid, i, pidx[i] );
	SETERR(1);
	return 0;
	}
#endif    
    nbrs[pidx[i]] = 1;
    }

PIgisum( nbrs, np, nbrs + np, procset );
cnt    = nbrs[me];
FREE( nbrs );
return cnt;
}

/*@
    PIGetSizePartners - Given an array of message lengths and processor ids 
                        to SEND to, return the size of the largest message
			that will be RECEIVED.

    Input Parameters:
.   pidx - array of processor ids
.   slen - array of message lengths
.   n    - number of elements in pidx
.   procset - processor subset	     
@*/
int PIGetSizePartners( pidx, slen, n, procset )
int     *pidx, *slen, n;
ProcSet *procset;
{
int cnt, *nbrs, i;
int np, me;

np = PInumtids;
me = PImytid;

nbrs = (int *)MALLOC( 2 * np * sizeof(int) );     CHKPTRN(nbrs);
for (i=0; i<np; i++) nbrs[i] = 0;
for (i=0; i<n; i++) {
#ifdef DEBUG_ALL
    if (pidx[i] >= np || pidx[i] < 0) {
	fprintf( stderr, 
     "[%d] Invalid processor id (pidx[%d]=%d) in PIGetSizePartners\n",
		PImytid, i, pidx[i] );
	SETERR(1);
	return 0;
	}
#endif    
    nbrs[pidx[i]] = slen[i];
    }

PIgimax( nbrs, np, nbrs + np, procset );
cnt    = nbrs[me];
FREE( nbrs );
return cnt;
}
