#ifndef lint
static char SCCSid[] = "@(#) ./comm/global/gcolx.c 07/23/93";
#endif

#include "comm/comm.h"
#include "comm/procset.h"
#include "comm/global/global.h"
#include <stdio.h>

extern void PIcor();

/* 
   This is gcol but with sizes known in advance.  The algorithm is to
   find the location in gbuf for the local contribution and then 
   merge the data together.  This is done by ORing the bits.
 */
void gcolxset( lbuf, gsizes, gbuf, procset, datatype )
char    *lbuf, *gbuf;
int     *gsizes, datatype;
ProcSet *procset;
{
int  size, i, lidx, np, loc;
char *work;


/* Find my position */
lidx = PSMYPROCID(procset);
np   = PSNUMNODES(procset);
loc  = 0;
size = 0;
for (i=0; i<lidx; i++) 
    loc += gsizes[i];
size = loc;
while (i < np)
    size += gsizes[i++];

MEMSET(gbuf,0,size);
MEMCPY(gbuf+loc,lbuf,gsizes[lidx]);
work = (char *) MALLOC( size );    CHKPTR(work);
/* Just do OR reduction of vector gbuf.  Later we should consider
   something more efficient (at least for large collections).  */
(*PIcomb)( gbuf, size, work, procset, sizeof(char), datatype, PIcor );
FREE( work );
}
