#ifndef lint
static char SCCSid[] = "@(#) ./comm/gfort.c 07/23/93";
#endif

/*
   This file contains Fortran interfaces for the communication routines
   and macros.
*/


#include "comm.h"
#include "comm/procset.h"
#include <stdio.h>
#define BZERO(a,n)         memset(a,0,n)

#if defined(FORTRANCAPS)
#define gisum_       GISUM
#define gdsum_       GDSUM
#define gimax_       GIMAX
#define gimin_       GIMIN
#define gdmax_       GDMAX
#define gdmin_       GDMIN
#define gsync_       GSYNC
#define gcol_        GCOL
#define gcolx_       GCOLX
#define gscatter_    GSCATTER
#define gtoken_      GTOKEN
#define numnodes_    NUMNODES
#define myprocid_    MYPROCID
#define psdestroy_   PSDESTROY
#define pspartition_ PSPARTITION
#elif !defined(FORTRANUNDERSCORE)
#define gisum_       gisum
#define gdsum_       gdsum
#define gimax_       gimax
#define gimin_       gimin
#define gdmax_       gdmax
#define gdmin_       gdmin
#define gsync_       gsync
#define gcol_        gcol
#define gcolx_       gcolx
#define gscatter_    gscatter
#define gtoken_      gtoken
#define numnodes_    numnodes
#define myprocid_    myprocid
#define psdestroy_   psdestroy
#define pspartition_ pspartition
#endif

/* variables to keep track of the ProcSets that we have allocated. */
static ProcSet **proclist = 0;
static int     proclast   = 0;
static int     procmax    = 25;

/* we keep an array of pointers to ProcSets which have been
   allocated, once that array is full we allocate a larger one,
   copy the pointers over and delete the old array.  proclist[0] = 0.
*/
int pspartition_( pval, iprocset )
int *pval;
int *iprocset;
{
  ProcSet **tmp;
  int   i;
  if (!proclist) {
    proclist = (ProcSet **) MALLOC(procmax*sizeof(ProcSet *));
    if (!proclist) return -1;
    BZERO(proclist,procmax*sizeof(ProcSet *));
    proclast = 1;
    proclist[0] = 0; 
  } 
  if (proclast < procmax) {
    proclist[proclast] = PSPartition(*pval,proclist[*iprocset]);
    if (!proclist[proclast]) return -1; 
    return proclast++;
  } 
  else {
    for (i=0; i<procmax; i++) {
      if (!proclist[i]) {
        proclist[i] = PSPartition(*pval,proclist[*iprocset]);
        if (!proclist[i]) return -1;
        return i;
      } 
    }  
  }  
  tmp = (ProcSet **) MALLOC(2*procmax*sizeof(ProcSet *)); if (!tmp) return -1;
  BZERO(tmp,2*procmax*sizeof(ProcSet *));
  for (i=0; i<procmax; i++) {
    tmp[i] = proclist[i];
  } 
  FREE(proclist); proclist = tmp; procmax = 2*procmax;
  proclist[proclast] = PSPartition(*pval,proclist[*iprocset]);
  if (!proclist[proclast]) return -1;
  return proclast++;
}

void psdestroy_( iprocset )
int *iprocset;
{
  PSDestroy( proclist[*iprocset] );
}

/*ARGSUSED*/
void gisum_( val, n, work, iprocset )
int *val, *n, *work;
int *iprocset;
{
  GISUM( val, *n, work, *iprocset ? proclist[*iprocset] : 0 );
}

/*ARGSUSED*/
void gdsum_( val, n, work, iprocset )
int *val, *n, *work;
int *iprocset;
{
  GDSUM( val, *n, work, *iprocset ? proclist[*iprocset] : 0 );
}

/*ARGSUSED*/
void gimax_( val, n, work, iprocset )
int *val, *n, *work;
int *iprocset;
{
  GIMAX( val, *n, work, *iprocset ? proclist[*iprocset] : 0 );
}

/*ARGSUSED*/
void gimin_( val, n, work, iprocset )
int *val, *n, *work;
int *iprocset;
{
  GIMIN( val, *n, work, *iprocset ? proclist[*iprocset] : 0 );
}

/*ARGSUSED*/
void gdmax_( val, n, work, iprocset )
int    *n;
double *val, *work;
int    *iprocset;
{
  GDMAX( val, *n, work, *iprocset ? proclist[*iprocset] : 0 );
}

/*ARGSUSED*/
void gdmin_( val, n, work, iprocset )
double  *val, *work;
int     *n;
int     *iprocset;
{
  GDMIN( val, *n, work, *iprocset ? proclist[*iprocset] : 0 );
}

/*ARGSUSED*/
void gsync_( iprocset )
int *iprocset;
{
  GSYNC( *iprocset ? proclist[*iprocset] : 0 );
}

/*ARGSUSED*/
void gcol_( lbuf, lsize, gbuf, gsiz, glen, iprocset, datatype )
char *lbuf, *gbuf;
int  *lsize, *gsiz, *glen, *datatype;
int  *iprocset;
{
  GCOL( lbuf, *lsize, gbuf, *gsiz, glen, 
        *iprocset ? proclist[*iprocset] : 0, *datatype );
}

/*ARGSUSED*/
void gcolx_( lbuf, gsizes, gbuf, iprocset, datatype )
char    *lbuf, *gbuf;
int     *gsizes, *datatype;
int *iprocset;
{
  GCOLX( lbuf, gsizes, gbuf, *iprocset ? proclist[*iprocset] : 0, *datatype );
}

/*ARGSUSED*/
void gscatter_( buf, size, issrc, iprocset, datatype )
char *buf;
int  *size, *issrc;
int  *iprocset;
int  *datatype;
{
  GSCATTER( buf, *size, *issrc, *iprocset ? proclist[*iprocset] : 0, 
	    *datatype );
}

/*ARGSUSED*/
int gtoken_( iprocset, i )
int *iprocset;
int *i;
{
  return GTOKEN( *iprocset ? proclist[*iprocset] : 0, *i );
}

int numnodes_()
{
  return NUMNODES;
}

int myprocid_()
{
  return MYPROCID;
}

