#ifndef lint
static char SCCSid[] = "@(#) ./blkcm/copy/util4dad.c 07/23/93";
#endif

/* 
    This file contains routines for moveing data from one slab to 
    another.  Inorder to make motion to/from a communications
    buffer efficient, special cases for compacted (unit stride)
    storage are included.
 */

#include "blkcm/bcp.h"

BCs_to_d4dadd( s, d )
slab *s, *d;
{
register double *sp3 = s->p;
register double *dp3 = d->p;
register double *sp1, *sp, *dp1, *dp, *sp2, *dp2;
register int    n4  = s->n4, n2, n1, dinc = d->s1, sinc = s->s1, n3;

while (n4--) {
    n3 = s->n3;
    dp2 = dp3;
    sp2 = sp3;
    while (n3--) {
	n2 = s->n2;
	dp1= dp2;
	sp1= sp2;
	while (n2--) {
	    n1 = s->n1;
	    dp = dp1;
	    sp = sp1;
	    while (n1--) {
		*dp += *sp;
		dp  += dinc;
		sp  += sinc;
		}
	    dp1 += d->inc1;
	    sp1 += s->inc1;
	    }
	dp2 += d->inc2;
	sp2 += s->inc2;
	}
    dp3 += d->inc3;
    sp3 += s->inc3;
    }
}

BCb_to_d4dadd( b, d )
slab   *d;
double *b;
{
register double *sp = b;
register double *dp3 = d->p;
register double *dp1, *dp, *dp2;
register int    n4  = d->n4, n2, n1, dpinc = d->s1, n3;

while (n4--) {
    n3  = d->n3;
    dp2 = dp3;
    while (n3--) {
	n2 = d->n2;
	dp1= dp2;
	while (n2--) {
	    n1 = d->n1;
	    dp = dp1;
	    while (n1--) {
		*dp += *sp++;
		dp  += dpinc;
		}
	    dp1 += d->inc1;
	    }
	dp2 += d->inc2;
	}
    dp3 += d->inc3;
    }
}
