/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/user/RCS/inet_to_x500.c,v $
 *
 *
 *  MODULE NAME:    inet_to_x500.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <ctype.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <syslog.h>

#include "gssapi_defs.h"
#include "cdc.h"


char *progname, *rindex();

extern int optind, opterr;
extern char *optarg;

main(argc, argv)
int  argc;
char **argv;
{
  char  targ_printable[GSS_C_MAX_PRINTABLE_NAME], inethost[FULLNAME_SZ];
  int   sflag = 0, c, errflg = 0;
  char  *cp, service[ANAME_SZ];
  gss_buffer_desc  input_name_buffer, output_name_buffer;
  gss_name_t    desired_targname;
  int           status, major_status;
  gss_OID       output_name_type;


  opterr = 0;
  bzero(inethost, sizeof(inethost));
  while ((c=getopt(argc, argv, "s:")) != EOF)
    switch(c) {
      case 's' :
        sflag = 1;
        strcpy(service, optarg);
        break;
      case '?' :
        errflg++;
        break;
    }

  if (argv[optind] != NULL) strcpy(inethost, argv[optind++]);
  if (optind != argc) errflg++;
  if (errflg) {
    progname = (cp = rindex(*argv, '/')) ? cp + 1 : *argv;
    printf("Usage: %s [-s service] internet_hostname\n", progname);
    printf("\t-s\tservice name (default is rcmd)\n");
    exit(1);
  }

  if (!strlen(inethost)) {
    printf("Internet hostname : ");
    gets(inethost);
    if (!*inethost)
      exit(0);
  }

  bzero(targ_printable, sizeof(targ_printable));
  strcpy(targ_printable, "SERVICE:");
  if (sflag == 0) strcat(targ_printable, "rcmd@");
  else {
    strcat(targ_printable, service);
    strcat(targ_printable, "@");
  }
  strcat(targ_printable, inethost);

  input_name_buffer.length = strlen(targ_printable);
  input_name_buffer.value = targ_printable;

  major_status = gss_import_name(&status,
    &input_name_buffer,
    GSS_C_NULL_OID,
    &desired_targname);

  major_status = gss_display_name(&status,
    desired_targname,
    &output_name_buffer,
    &output_name_type);

  printf("'%s'\n",output_name_buffer.value);
}
