/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/cfile/RCS/tkt_string.c,v $
 *
 *
 *  MODULE NAME:    tkt_string.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <sys/param.h>
#include "cdc.h"

char *getenv();

/*
 * This routine is used to generate the name of the file that holds
 * the user's cache of server tickets and associated session keys.
 *
 * If it is set, cdc_ticket_string contains the ticket file name.
 * Otherwise, the filename is constructed as follows:
 *
 * If it is set, the environment variable "CDCTKFILE" will be used as
 * the ticket file name.  Otherwise TKT_ROOT (defined in "cdc.h") and
 * the user's uid are concatenated to produce the ticket file name
 * (e.g., "/tmp/cred123").  A pointer to the string containing the ticket
 * file name is returned.
 */

static char cdc_ticket_string[128] = "";

char *spx_tkt_string(key, id)
char *key, *id;
{
    char *env;

    if (id != NULL)
      (void) sprintf(cdc_ticket_string, "%s_%s_%s",TKT_ROOT,key,id);
    else {
      if ((env = getenv("SPHINX_CLAIMANT_FILE")) != NULL)
        (void) strcpy(cdc_ticket_string, env);
      else
        (void) sprintf(cdc_ticket_string, "%s_%s",TKT_ROOT,key);
    }
    return cdc_ticket_string;
}
