/*
 * Copyright (c) 1994 David I. Bell
 * Permission is granted to use, distribute, or modify this source,
 * provided that this copyright notice remains intact.
 */


#if !defined(ALLOC_H)
#define ALLOC_H

#include "have_malloc.h"
#include "have_newstr.h"
#include "have_string.h"
#include "have_vs.h"

#ifdef HAVE_MALLOC_H
# include <malloc.h>
#else
# if defined(__STDC__) && __STDC__ != 0
   extern void *malloc();
   extern void *realloc();
   extern void free();
# else
   extern char *malloc();
   extern char *realloc();
   extern void free();
# endif
#endif

#ifdef HAVE_STRING_H
# include <string.h>

#else

# if defined(HAVE_NEWSTR)
extern void memcpy();
extern void memset();
#  if defined(__STDC__) && __STDC__ != 0
extern void *strchr();
#  else
extern char *strchr();
#  endif
# else /* HAVE_NEWSTR */
extern void bcopy();
extern void bfill();
extern char *index();
# endif /* HAVE_NEWSTR */
extern void strcpy();
extern void strncpy();
extern void strcat();
extern int strcmp();
extern long strlen();	/* should be size_t, but old systems don't have it */

#endif


#if !defined(HAVE_NEWSTR)
#undef memcpy
#define memcpy(s1, s2, n) bcopy(s2, s1, n)
#undef memset
#define memset(s, c, n) bfill(s, n, c)
#undef strchr
#define strchr(s, c) index(s, c)
#endif /* HAVE_NEWSTR */


#if !defined(HAVE_VSPRINTF)
/*
 * Hack aleart!!!
 *
 * Systems that do not have vsprintf() need something.  In some cases
 * the sprintf function will deal correctly with the va_alist 3rd arg.
 * Hope for the best!
 */
#define vsprintf sprintf
#endif /* ! HAVE_VSPRINTF */

#endif /* !ALLOC_H */
