file=$objdir/Makefile

echo Extracting $file
rm -f $file

# Path to directories
case "$src_dir"    in /*) src=$src_dir ;;    *) src=../$src_dir ;; esac
case "$data_dir"   in /*) data=$data_dir ;;  *) data=../$data_dir ;; esac
case "$doc_dir"    in /*) doc=$doc_dir ;;    *) doc=../$doc_dir ;; esac
case "$perl_dir"   in /*) prl=$perl_dir ;;   *) prl=../$perl_dir ;; esac
case "$emacs_dir"  in /*) emx=$emacs_dir ;;  *) emx=../$emacs_dir ;; esac
case "$config_dir" in /*) cfg=$config_dir ;; *) cfg=../$config_dir ;; esac

# File lists
if test -n "$KERNEL"; then kernel="kernel mp"; else kernel="mp"; fi
gp="gp gp_init gp_rl"
graph="plot plotport"
language=`ls $src_dir/language/*.c | sed 's,.*/\(.*\)\.c,\1,'`
basemath=`ls $src_dir/basemath/*.c | sed 's,.*/\(.*\)\.c,\1,'`
modules=`ls $src_dir/modules/*.c   | sed 's,.*/\(.*\)\.c,\1,'`

khlist="kernelinline mpinline"
hlist="\
  genpari\
  types\
  cast\
  gencom\
  errmessages\
"
if test m68k = "$asmarch"; then
  hlist="$hlist gen68k"
else
  hlist="$hlist genport"
fi

HEADERS=''
for f in $khlist; do
  HEADERS="$HEADERS $src/kernel/$f.h";
done
for f in $hlist; do
  HEADERS="$HEADERS $src/headers/$f.h";
done

# We don't want to recompile everything when only changing a prototype
hlist="$hlist gendecl"

OBJS=''
for f in $kernel $basemath $modules $language; do
  OBJS="$OBJS $f.o"
done
OBJSGP=''
for f in $gp $graph; do
  OBJSGP="$OBJSGP $f.o"
done

case "$which_graphic_lib" in
none)
  PLOTFILE=plotnull.c
  PLOTCFLAGS=
  PLOTLIBS=
  plotrunpath=
  ;;
sunview)
  PLOTFILE=plotsun.c
  PLOTCFLAGS=
  PLOTLIBS='-lsuntool -lsunwindow -lpixrect'
  plotrunpath=
  ;;
X11)
  PLOTFILE=plotX.c
  PLOTCFLAGS=-I$Xincroot
  PLOTLIBS="-L$X11 -lX11 $extralib"
  if test "$osname" = concentrix; then PLOTLIBS="-lX11"; fi
  plotrunpath=$X11
  ;;
esac
## Gnuplot ???

case "$readline" in
  '')rr="#";;
  *) rr='';;
esac

case "$runpathprefix" in
  -R) RUNPTH_FINAL="-R$runpath"
      if test -n "$plotrunpath"; then
        RUNPTH_FINAL="$RUNPTH_FINAL -R$plotrunpath"
      fi
      RUNPTH="-R$TOP/$objdir $RUNPTH_FINAL";;
  *-rpath*)
      tmp="$runpath:$plotrunpath"
      RUNPTH_FINAL="$runpathprefix $tmp"
      RUNPTH="$runpathprefix $TOP/$objdir:$tmp";;
esac

if test $DLLD = /bin/false; then
  static=y; exec="gp-sta"; else exec="gp-sta gp-dyn"; fi
case "$static" in
  n) dft=dyn ;;
  y) dft=sta ;;
esac

cat > $file << EOT
# Makefile for Pari/GP -- $pretty
#
#  This file was created by Configure. Any change made to it will be
#  lost when Configure is run.
#
SHELL      = $make_sh

AS         = $AS
ASFLAGS    = $ASFLAGS

CC         = $CC
CPPFLAGS   = -I. -I$src/headers -I$src/kernel
CFLAGS     = $cflags -DLIB_PARI
LD         = $LD
LDFLAGS    = $LDFLAGS
DLLD       = $DLLD
DLLDFLAGS  = $DLLDFLAGS
EXTRADLLDFLAGS  = $EXTRADLLDFLAGS

RUNPTH       = $RUNPTH
RUNPTH_FINAL = $RUNPTH_FINAL
LDDYN        = $LDDYN
DLCFLAGS     = $DLCFLAGS
LIBS = -lm $LIBS

RM = rm -f
MV = mv -f
LN = $ln_s

# Change these installation directories to suit your needs.

LIBDIR = $libdir
BINDIR = $bindir
DATADIR= $datadir
MANDIR = $mandir
MISCDIR = $miscdir
INCLUDEDIR = $includedir

INSTALL = $cfg/install
INSTALL_PROGRAM = \$(INSTALL)
INSTALL_DATA = \$(INSTALL) -m 644

# Graphic library.
PLOTFILE   = $PLOTFILE
PLOTCFLAGS = $PLOTCFLAGS
PLOTLIBS   = $PLOTLIBS

# Uncomment to use GNU readline.
$rr RLINCLUDE = $RLINCLUDE
$rr RLLIBS    = $RLLIBS

TOPLDDYN     = -L$TOP/$objdir \$(RLLIBS)

OBJS   = $OBJS
OBJSGP = $OBJSGP

dft gp: gp-$dft lib-$dft ../gp$suffix$exe_suff
	-

../gp$suffix$exe_suff: gp-$dft
	-\$(RM) \$@
	-\$(LN) $objdir/gp-$dft$exe_suff \$@

all: gp-sta gp-dyn lib-sta lib-dyn

lib-sta: libpari.a
lib-dyn: libpari.$somake

libpari.a: \$(OBJS)
	-\$(RM) \$@
	ar r \$@  \$(OBJS)
EOT
if test -n "$ranlib"; then
cat >> $file << EOT
	$ranlib \$@
EOT
fi
cat >> $file << EOT

libpari.$somake: \$(OBJS)
	-\$(RM) libpari.$somake
	\$(DLLD) -o \$@ \$(DLLDFLAGS) \$(OBJS) \$(EXTRADLLDFLAGS)
EOT
if test "$somake" != "$sodest"; then
cat >> $file << EOT
	-\$(RM) libpari.$sodest
	-\$(MV) libpari.$somake libpari.$sodest
	-\$(LN) libpari.$sodest libpari.$somake
	-\$(RM) libpari.$DLSUFFIX
	-\$(LN) libpari.$sodest libpari.$DLSUFFIX
EOT
fi
cat >> $file << EOT

gp-sta gp-sta-install: \$(OBJS) \$(OBJSGP)
	\$(LD) -o gp-sta \$(LDFLAGS) \$(OBJS) \$(OBJSGP) \$(RUNPTH) \$(RLLIBS) \$(PLOTLIBS) \$(LIBS)

gp-dyn: \$(OBJSGP) libpari.$somake
	\$(LD) -o \$@ \$(LDFLAGS) \$(OBJSGP) \$(RUNPTH) \$(TOPLDDYN) \$(LDDYN) \$(PLOTLIBS) \$(LIBS)

gp-dyn-install: \$(OBJSGP) libpari.$somake
	\$(LD) -o gp-dyn \$(LDFLAGS) \$(OBJSGP) \$(RUNPTH_FINAL) \$(TOPLDDYN) \$(LDDYN) \$(PLOTLIBS) \$(LIBS)

bench: $exec dobench
test: $exec dotest
test-compat: $exec dotest-compat
test-graphic: $exec dotest-graphic

ftest: gp-dyn
	@dotestARG="dyn"; export dotestARG; make dotest
fbench: gp-dyn
	@dotestARG="dyn"; export dotestARG; make dobench

cleantest:
	\$(RM) out.* pari.ps

dobench::
	@$src/test-bench/dotest $sizeof_long
dotest::
	@$src/test/dotest $sizeof_long
dotest-compat::
	@$src/test/dotest $sizeof_long -c
dotest-graphic::
	@$src/test/dotest $sizeof_long -g

install: install-lib-$dft install-include install-bin install-man install-misc install-data

install-lib-dyn: libpari.$sodest
	-mkdir -p \$(LIBDIR)
	\$(INSTALL_DATA) libpari.$sodest \$(LIBDIR)/libpari.$sodest
EOT
if test "$somake" != "$sodest"; then
cat >> $file << EOT
	-\$(RM) \$(LIBDIR)/libpari.$somake
	-\$(LN) libpari.$sodest \$(LIBDIR)/libpari.$somake
	-\$(RM) \$(LIBDIR)/libpari.$DLSUFFIX
	-\$(LN) libpari.$sodest \$(LIBDIR)/libpari.$DLSUFFIX
EOT
fi
cat >> $file << EOT

install-lib-sta: libpari.a
	-mkdir -p \$(LIBDIR)
	-\$(RM) \$(LIBDIR)/libpari.a
	\$(INSTALL_DATA) libpari.a \$(LIBDIR)/libpari.a.$version
	-\$(LN) libpari.a.$version \$(LIBDIR)/libpari.a

install-include:
	-mkdir -p \$(INCLUDEDIR)
	-for i in $khlist; do \\
	   \$(INSTALL_DATA) $src/kernel/\$\$i.h     \$(INCLUDEDIR); done
	-for i in $hlist; do \\
	   \$(INSTALL_DATA) $src/headers/\$\$i.h     \$(INCLUDEDIR); done
	\$(INSTALL_DATA) $src/kernel/asmsparcv8.h  \$(INCLUDEDIR)
	\$(INSTALL_DATA) config.h                    \$(INCLUDEDIR)

install-bin: gp-$dft-install
	-mkdir -p \$(BINDIR)
	\$(INSTALL_PROGRAM) gp-$dft \$(BINDIR)/gp-$version
	strip \$(BINDIR)/gp-$version
	-\$(RM) \$(BINDIR)/gp
	-\$(LN) gp-$version$exe_suff \$(BINDIR)/gp$exe_suff

install-bin-sta: gp-sta-install
	-mkdir -p \$(BINDIR)
	\$(INSTALL_PROGRAM) gp-sta \$(BINDIR)/gp-$version
	strip \$(BINDIR)/gp-$version
	-\$(RM) \$(BINDIR)/gp
	-\$(LN) gp-$version$exe_suff \$(BINDIR)/gp$exe_suff

install-man::
	-mkdir -p \$(MANDIR)
	\$(INSTALL_DATA) $doc/gp.1 \$(MANDIR)

install-misc: install_emacs_files
	-mkdir -p \$(MISCDIR)
	\$(INSTALL_DATA)    $doc/macros.tex     \$(MISCDIR)
	\$(INSTALL_DATA)    $doc/users.help.tex \$(MISCDIR)
	\$(INSTALL_DATA)    $doc/usersch3.tex   \$(MISCDIR)
	\$(INSTALL_PROGRAM) $prl/gphelp         \$(MISCDIR)
	\$(INSTALL_DATA)    $prl/translations   \$(MISCDIR)

install-data:
	-mkdir -p \$(DATADIR)
	@-for f in $data/*; do \$(INSTALL_DATA)  \$\$f \$(DATADIR); done 2>/dev/null

install_emacs_files: pari.elc
	-mkdir -p \$(MISCDIR)
	-\$(INSTALL_DATA)   $emx/pari.elc       \$(MISCDIR)
	\$(INSTALL_DATA)    $emx/pari.el        \$(MISCDIR)
	\$(INSTALL_DATA)    $emx/pari.menu      \$(MISCDIR)
	\$(INSTALL_DATA)    $emx/pariemacs.txt  \$(MISCDIR)

EOT

if test -n "$emacs"; then
cat >> $file << EOT
pari.elc: $emx/pari.el
	-rm -f $emx/compile
	@echo "(byte-compile-file \"$emx/pari.el\")"> $emx/compile
	@echo "Byte-Compiling pari.el..."
	-$emacs -batch -l $emx/compile;
EOT
fi

cat >> $file << EOT
clean: cleantest
	-\$(RM) *.o *.s libpari.* gp-dyn gp-sta

# Ceci est la liste des headers inclus par genpari.h, pour les dependances
.headers: $HEADERS
	@touch \$@

EOT

if test -n "$create_asmfile"; then
cat >> $file << EOT
$KERNEL:	$depend_asmfile
	$create_asmfile
EOT
fi

for dir in kernel basemath modules language gp graph; do
  eval list='$'$dir
  for f in $list; do

  __source__="$src/$dir/$f.c"
  __buildc__="\$(CC) -c \$(CFLAGS) \$(CPPFLAGS)"
  __depend__=".headers"
  case "$f" in
  kernel)
    __source__="$KERNEL"
    __buildc__="$kbuild"
    __depend__=""
    ;;
  plot)
    __source__="$src/graph/\$(PLOTFILE)"
    __buildc__="$__buildc__ \$(PLOTCFLAGS)"
    __depend__="$__depend__ $src/graph/rect.h"
    ;;
  gp|gp_rl)
    __buildc__="$__buildc__ -I$src/language \$(RLINCLUDE)"
    __depend__="$__depend__ $src/language/anal.h $src/gp/gp.h ./config.h"
    ;;
  gp_init|plotport)
    __buildc__="$__buildc__ -I$src/graph"
    __depend__="$__depend__ $src/graph/rect.h"
    ;;
  init|es|sumiter)
    __depend__="$__depend__ $src/language/anal.h"
    ;;
  anal)
    __depend__="$__depend__ $src/language/anal.h $src/headers/nf.h"
    ;;
  base1|bibli1|buch2)
    __depend__="$__depend__ $src/headers/nf.h"
    ;;
  esac

  cat >> $file  <<!!
$f.o: $__depend__ $__source__
	$__buildc__ -o $f.o $__source__
!!

  done
done
