/* bentley.h 1.4 6/25/92 */
/*  Original Author: Jon Bentley				    */
/*    (Source code obtained from DIMACS shared account, March 1992.)*/
/*								    */
/*  Header file/mrandom interface by Clark Thomborson, May 1992     */
/*  Vectorized interface by Clark Thomborson, June 1992		    */

/*  This file contains a set of c-language functions for generating */
/*  uniform integers.   This is a COMPLETELY PORTABLE generator.    */
/*  It will give IDENTICAL sequences of random numbers for any      */
/*  architecture with at least 30-bit integers, regardless of the   */
/*  integer representation, MAXINT value, or roundoff/truncation    */
/*  method, etc.                                                    */

/*  This Truly Remarkable RNG is described more fully in            */
/*  J. Bentley's column, ``The Software Exploratorium ''            */
/*  to appear in Unix Review in 1991.                               */ 
/*  It is based on one in Knuth, Vol 2, Section 3.2.2 (Algorithm A) */ 

#define PRANDMAX 1000000000
#define RNGstatesize_2	57
#define RNGrangem1_2	PRANDMAX-1
#define RNGfileLINE0_2	"(Bentley's lagged Fibbonacci)\n"

/*----RNG Initializer------------*/
/* Call once before using lprand */ 

void sprand (/* long seed, rngstate[RNGstatesize_2] */);

/*---------RNG---------------------*/
/* Writes a vector v[] of n long integers from the  */
/* range 0...PRANDMAX-1            		    */ 

void lprandv(/* long rngstate[RNGstatesize_2]; long n,v[]; */);

/*---------CKRAND---------------------*/
/* Returns 0 if rngstate is corrupted */

int ckrand(/* long rngstate */);
