/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#include "style.h"
#undef comp

#ifdef MPWC
#define MACINTOSH
#endif

/* A default file search path must be provided below,
 * and can be modified via the environment variable MacaulayPath,
 * then by the file Macaulay.path, then via the path command.
 * Feel free to modify this default path for your local installation.
 * Macintosh sample: ":,A:user:Macaulay:bin:"
 * Unix sample: ".:/usr/local/math/Macaulay/bin"
 */

#ifdef MPWC
char *MclyPath = ":";
#else /* Unix */
char *MclyPath = ".";
#endif

/* The default current directory can be initialized, but to what? */
char *MclyCdir = NULL;

/*
 * The location of the following two files is installation dependent.
 * If they can be found via MclyPath, no changes are needed below.
 */

char *helpFile = "Macaulay.help" ;
char *newFile  = "Macaulay.new" ;

extern int timer ;
long startTime ;    

/*------------------------------------------------------
 *
 *  interrupt, timer and fontsize code for Macintosh
 *
 *------------------------------------------------------*/

#ifdef MPWC

#include <Types.h>
#include <Events.h>
#include <OSEvents.h>

#ifdef SIOW

spec_init()
{
}

rmmouse()
{
	/* struct EventRecord myEvent ; */
	
	FlushEvents(mDownMask, 0) ;
	/* while (GetNextEvent(mDownMask, &myEvent) != 0) ; */
}

intr_shell()
{
	struct EventRecord myEvent ;
	
	if (GetNextEvent(mDownMask, &myEvent) != 0) {
		print("\n") ;
		shell() ;
		rmmouse() ;
	}
}

boolean
have_intr()
{
	struct EventRecord myEvent ;
	
	if (GetNextEvent(mDownMask, &myEvent) != 0) {
		rmmouse() ;
		return(TRUE) ;
	}
		return(FALSE) ;
}

#else /* not SIOW */

#include <Signal.h>
#include <CursorCtl.h>

int intFlag ;   /* set to 1 if an interrupt is given */

void handle (int sig)
{
	#pragma unused(sig);
	++intFlag;
}

spec_init()
{
	intFlag = 0 ;
	signal(SIGINT, &handle) ;
}

flush_intr()
{
	int c;
	
	signal(SIGINT, &handle) ;
	while (intFlag > 0) {
		while ((c=getchar())!=EOF) ;
		clearerr(stdin) ;
		intFlag--;
	}
}

beachball()
{
	Show_Cursor(HIDDEN_CURSOR) ;
	SpinCursor(10) ;
}

intr_shell()
{
	beachball() ;
	if (intFlag) {
		flush_intr() ;
		print("\n") ;
				shell() ;
	}
}

boolean
have_intr()
{
	beachball() ;
	if (intFlag) {
		flush_intr() ;
		return(TRUE) ;
	}
	else
		return(FALSE) ;
}

rmmouse()
{
	intFlag = 0 ;
}

#endif /* not SIOW */
#endif /* MPWC */

#ifdef SUN
#define MOUSE SIGINT

#include <signal.h>
/*(*signal())() ;*/
int intFlag ;   /* set to 1 if an interrupt is given */

handle()
{
    intFlag = 1 ;
    signal(MOUSE, handle) ;
}

spec_init()
{
    intFlag = 0 ;
    signal(MOUSE, handle) ;
}

intr_shell()
{
    if (intFlag == 1) {
        intFlag = 0 ;
        print("\n") ;
        shell() ;
        intFlag = 0 ;
    }
}

boolean
have_intr()
{
    if (intFlag == 1) {
    rmmouse() ;
    return(TRUE) ;
    }
    return(FALSE) ;
}

rmmouse()
{
    intFlag = 0 ;
}

prsetup() {}

#endif

setTextSize(n)
int n ;
{
#ifdef ANSI
 #pragma unused(n)
#endif
}

#ifdef SUN
#define UNIX_TIMER
#define TICK 60
#endif

#ifdef RIDGE
#define UNIX_TIMER
#define TICK 1000
#endif

#ifdef UNIX_TIMER

#include <sys/types.h>
#include <sys/times.h>

static struct tms time_buf ;

markTime()
{
    times(&time_buf) ;
    startTime = time_buf.tms_utime + time_buf.tms_stime ;
}

long
nSeconds()
{
    times(&time_buf) ;
    return((time_buf.tms_utime + time_buf.tms_stime - startTime)/TICK) ;
}

long
get_ticks()
{
    times(&time_buf) ;
    return time_buf.tms_utime + time_buf.tms_stime ;
}

#endif /* UNIX_TIMER */

#ifdef MACINTOSH

markTime()
{
    startTime = TickCount() ;
}

long
nSeconds()
{
    long n ;

    n = TickCount() - startTime ;
    return(n / 60) ;
}

long
get_ticks()
{
  return TickCount();
}

#endif /* MACINTOSH */

/*------------------------------------------------------
 *
 *  timer routine (machine indep.)
 *
 *------------------------------------------------------*/

prTime(str)
char *str ;
{
    long tot, s, m ;

    if (timer <= 0) return ;
    tot = nSeconds() ;
    if (tot == 0) return ;
    s = tot % 60 ;
    m = tot / 60 ;
    newline() ;
    print("%s ",str) ;
    if (m > 1) 
        print("%ld minutes and " , m) ;
    else if (m == 1)
        print("1 minute and ") ;
    if (s != 1)
        print("%ld seconds\n", s) ;
    else 
        print("1 second\n") ;
}

#ifdef MACINTOSH
prsetup()
{
}
#endif

