
#ifndef VECTOR_INCLUDED
#define VECTOR_INCLUDED

#include "mat.h"

typedef matrix	vector;

#define vec_row		mat_row
#define vec_col		mat_col
#define vec_length	vec_col

#define vec_entry(h, i)		mat_entry(h, i)
#define vec_elt_minus1_ptr(h)	(mat_elt0_ptr(h))
#define vec_elt(h, i)		vec_entry(h, (i)+1)
/* #define vec_elt_minus1_ptr(h)	(&(mat_elt(h)[-1])) */

#define vec_new( i )		mat_new( 1, i )
#define vec_incref		mat_incref
#define vec_delete		mat_delref
#define vec_incref_entries	mat_incref_entries

#define vec_stk_to_vec( cr, sn, it, pv ) \
		mat_stk_to_blk( cr, sn, it, pv, 0, 0 )

#define vec_vec_to_stk( cr, v, psn, pit ) \
		mat_blk_to_stk( cr, v, psn, pit )

/*
** Macros to hide allocation of unpacked versions of matrices versus
** actual use of matrices.
*/

#define vec_alloc_result_unpkd( respack, c, cprime, n ) \
		mat_alloc_result_unpkd( respack, c, cprime, 1, n )

#define vec_create_result( ring, respack, c, cprime ) \
		mat_create_result( ring, respack, c, cprime )

#define vec_result_pkd( ring, c ) \
		mat_result_pkd( ring, c )

#define vec_create_unpkd( ring, a, aprime, n ) \
		mat_create_unpkd( ring, a, aprime, 1, n )

#define vec_create_unpkd_copy( ring, a, aprime, n ) \
		mat_create_unpkd_copy( ring, a, aprime, 1, n )

#define vec_free_unpkd( a, aprime ) \
		mat_free_unpkd( a, aprime )


#endif /* VECTOR_INCLUDED */

