/*  inthdl.e

Specifications for the calling interface to the inthdl_ part of the
multi-precision integer arithmetic package
*/

#ifndef INCLUDED_INTHDL_SPEC_H
#define INCLUDED_INTHDL_SPEC_H


/*
Total number of buffers allocated:
*/

#define INTHDL_TOTAL_BUFS	20


/*
Number of beta digits in each buffer:
*/

#define INTHDL_BUF_DIGITS	50


/*
Type for the t_handle of an integer stored in a block; such integers have
absolute value greater than or equal to integer_BETA (except sometimes
during the internal workings of the package):
*/

#if 0
typedef t_handle	inthdl_handle;
#endif

/*
Type for the sign and inthdl buf indices:
*/

#if 0
typedef short	inthdl_sign;
typedef short	inthdl_buf_index;
#endif

extern inthdl_buf_index	inthdl_buf_next_index;
extern inthdl_handle	inthdl_buf[];

/*
Type for a "beta-digit", that is, an ordinary machine integer with absolute
value less than integer_BETA (this may already have been defined, depending
on whether integer.e has been included or not):
*/

#ifndef	integer_BETA
#if 0
typedef t_word	integer_small;
#endif
#endif

/*
The following type is for general single- or multi-precision integers, re-
presented either as a small integer, i.e., a beta-digit, or as an inthdl_handle
marked in a special way (it is normally defined in integer.e; the follow-
ing definition is needed if integer_spepc.h has not been incuded):
*/

#ifndef	integer_BETA
#if 0
typedef t_word	integer_big;
#endif
#endif

/*
The following is normally defined in integer.e - see the comments there.
If that file has not been included, we make the definition here instead.
*/

#ifndef	integer_BETA
#if 0
typedef void	(*integer_break_action)( /* long int */ );
#endif
#endif

/*
The following two macros convert between an integer_big which is a specially
marked t_handle, and the value of the t_handle.  Note that these macros assume
that Blockhandler handles are negative.  The first macro converts a t_handle
to the special form:
*/

#ifdef POSH
#define inthdl_handle_to_big(h) (integer_BETA + (h))
#else
#define inthdl_handle_to_big(h) (integer_BETA - (h))
#endif

/*
The second macro converts an integer_big (known to be a marked t_handle)
back to the t_handle:
*/

#ifdef POSH
#define inthdl_big_to_handle(i) ((i) - integer_BETA)
#else
#define inthdl_big_to_handle(i) (integer_BETA - (i))
#endif


/*
The following type may be used by callers of the inthdl_ routines for data
representing the length (that is, the number of beta-digits) in a big
integer:
*/

#if 0
typedef	t_word	inthdl_length;
#endif

/*
The following increments the reference count of the specified integer block,
and returns its argument:
*/

#define inthdl_incref(h)	block_incref(h)
/*
The following is the "remove" call, which decrements the reference count
then deletes the block if the reference count is now zero:
*/

#define	inthdl_delref(h)	block_decref_delete(h)


/*
Macros for debugging printout
*/

#ifdef DEVELOP

#ifdef	INTBIG_MASTER_DEBUG_DEF
t_word	intbig_debug_flag = 0;
#else
extern t_word	intbig_debug_flag;
#endif

#define DEBUG_INTHDL(x)	if(intbig_debug_flag) inthdl_debug x
#define DEBUG_INTHDL_0(m)	DEBUG_INTHDL((m, 0))
#define DEBUG_INTHDL_1(m,a)	DEBUG_INTHDL((m, 1, a))
#define DEBUG_INTHDL_2(m,a,b)	DEBUG_INTHDL((m, 2, a, b))

#define DEBUG_INTHDL_BETA(m,a,b) \
	if(intbig_debug_flag) inthdl_debug_beta( m, a, b )

#define DEBUG_INTHDL_PRINTF \
	if(intbig_debug_flag) intbig_debug_msg( "" ); \
	if(intbig_debug_flag) bh_info_message

#else

#define DEBUG_INTHDL(x)
#define DEBUG_INTHDL_0(m)
#define DEBUG_INTHDL_1(m,a)
#define DEBUG_INTHDL_2(m,a,b)

#define DEBUG_INTHDL_BETA(m,a,b)

#define DEBUG_INTHDL_PRINTF

#endif

#include "inthdl_protos.h"

#endif /* INCLUDED_INTHDL_SPEC_H */

