/*******************************************************************************
-----------------------------------------------------------------------------

    ACHTUNG:
    Zur Vermeidung von zu grossen Kompatibilitaetsproblemen duerfen
    Aenderungen in den Strukturdefinitionen nur nach gemeinsamer
    Eroerterung bzw. Einigung zwischen der Cayley- und der Kant-Gruppe
    durchgefuehrt werden.
    Sydney, 25.9.1992             John Cannon, Johannes Gf. Schmettow

-----------------------------------------------------------------------------

    ATTENTION:

    To avoid major problems of incompatibility, changes to the structure
    definitions should only be made after common discussion and agreement
    between the Cayley and Kant groups.

    Sydney, 25/9/1992             John Cannon, Johannes Ct. Schmettow

-----------------------------------------------------------------------------
                   
anf_ideal.h
   
Header file for ideals in algebraic number fields.
This file should only be #included by anf.h.
 
An ideal ("anf_ideal") is a C-structure which provides data for
  - a two element (normal) presentation
  - a Z-basis presentation
  - additional flags which give information about
    - which normal presentation
    - whether the Z-basis presentation is Hermite reduced
    - the minimum of the positive integers in the ideal.
 
History:
        92-09-17 JS        Move to Cayley V4
        92-06-04 JS        split off from anf.h

*******************************************************************************/


/*******************************************************************************
/
/  Structure definition for ideals
/
*******************************************************************************/
 
typedef struct
	{
		t_block_header	trbl_hdr;
 
		anf_elt		generator_1;	
		anf_elt		generator_2;
		integer_big	g_set;
 
		matrix		tran;
		integer_big	tran_den;
		integer_small	hermite_flag;
 
		integer_big	minimum;
 
		integer_small	degree;
	} 	
	anf_ideal_struct;

 
/*******************************************************************************
/
/   Macros for accessing structure items of ideals
/
*******************************************************************************/
  
 
/*
    access macro for table element (internal use)
*/
  
#define anf_ideal_access(h)	((anf_ideal_struct *) mem_access(h))

/*
    macros for accessing items of 2-Element-Presentation
       - first generator (usually an integer)
       - second generator
       - the set referring to which a normal presentation is given
*/
  
#define anf_ideal_gen1(h)	(anf_ideal_access(h) -> generator_1)
#define anf_ideal_gen2(h)	(anf_ideal_access(h) -> generator_2)
#define anf_ideal_gen_g(h)	(anf_ideal_access(h) -> g_set)
 
 
/* 
    Is a 2-Element-Presentation given?
       - yes
       - yes and this presentation is "normal"
*/
 
#define anf_ideal_is_2(h)	 (anf_ideal_gen_g(h) != 0)
#define anf_ideal_is_2_normal(h) (anf_ideal_gen_g(h) > 1)
 
/*
    macros for accessing items of Z-Basis-Presentation
       - transition matrix
       - denominator of transition matrix
       - flag for indicating whether matrix is Hermite reduced (internal)
         (>0: upper   <0: lower   =0: no Hermite form)
*/
 
#define anf_ideal_tran(h)	(anf_ideal_access(h) -> tran)
#define anf_ideal_tran_den(h)	(anf_ideal_access(h) -> tran_den)
#define anf_ideal_tran_hnf(h)	(anf_ideal_access(h) -> hermite_flag)
#define anf_ideal_is_z(h)	(anf_ideal_tran(h) != MEM_NH) 
 
/*
    accessing and setting HNF flags
*/
 
#define anf_ideal_tran_is_hnf(h)  	(anf_ideal_tran_hnf(h))
#define anf_ideal_tran_is_upper_hnf(h)  (anf_ideal_tran_hnf(h) >  0)
#define anf_ideal_tran_is_lower_hnf(h)  (anf_ideal_tran_hnf(h) <  0)
#define anf_ideal_tran_set_upper_hnf(h) (anf_ideal_tran_hnf(h) =  1)
#define anf_ideal_tran_set_lower_hnf(h) (anf_ideal_tran_hnf(h) = -1)
 
/*
    the minimum of positive integers in the ideal
*/
 
#define anf_ideal_min(h)	(anf_ideal_access(h) -> minimum)
#define anf_ideal_min_known(h)	(anf_ideal_min(h))
 
/*
    degree of inertia (if known the norm must be minimum^degree)
*/
 
#define anf_ideal_degree(h)	   (anf_ideal_access(h) -> degree)
#define anf_ideal_degree_known(h)  (anf_ideal_degree(h))
    
 
/*  
    incrementing the reference counter of an ideal
*/
  
#define anf_ideal_incref(h)		block_incref(h)
