#include "kant.h"
#include "anf_rel_sort.h"




t_void
rel_order_fincke_rbounds_calc WITH_7_ARGS (
	order,         ord,
	order,         sub_ord,
	vector,	       K,
	anf_rel_sort,  sort,
	vector,	       lambdas,
	vector *,      ubounds,
	vector *,      lbounds
)
/*******************************************************************************
 
Description:
 
	This function calculates the bounds of r_i^(j).

 
Calling sequence:
 
 	rel_order_fincke_rbounds_calc(ord, sub_ord, K, sort, lambdas, 
	                              &ubounds, &lbounds);


        order  	          ord      = t_handle of an order 
        order  	          sub_ord  = t_handle of an sub order of ord
        vector	 	  K        = the values of the relative norm equations
				     (t_reals)
        anf_rel_sort 	  sort     = the sorting of the conjugetes over sub_ord
        vector	 	  lambdas  = the values of the relative zeroes
				     (t_reals)
        vector	 	  ubounds  = the upper bounds of r_i^(j) (vectors of integer_small)
        vector	 	  lbounds  = the lower bounds of r_i^(j) (vectors integer_small)

 
History:
 
	92-06-23 AJ    written
 
*******************************************************************************/
{
  	block_declarations;

        t_handle          R, Z;

        t_real          sum1, sum2, sum3, sum4, reg;
        t_real          temp1,temp2, temp3, temp4, lambda_log;

        vector          units_norms_log, units_norms_tst, lll_units, lll_units_log;
        anf_elt         elt_h1, elt_h2, elt_h3;
        
        matrix          units_logs, mat_h1, mat_int;         
                                                                    
        integer_small   nm, n, m, i, j, l, ind, sub_r1, sub_r2, sub_r1r2;
        integer_small   r, r2, r1;     /* signatur and r from ord */

        integer_big     d1, d2;

        


/*** Initialisation  **********************************************************/


        Z= m_z_str_incref(structure_z);
	R= order_reals (ord);
  	nm= order_abs_degree (ord);
  	n= order_abs_degree (sub_ord);
   	sub_r1= order_r1(sub_ord);
  	sub_r2= order_r2(sub_ord);
	sub_r1r2= sub_r1 + sub_r2;
 	m= nm/n;  

        r1 = order_r1 (ord);
        r2 = order_r2 (ord);
        r  = order_r1 (ord) + order_r2 (ord) - 1;

        *ubounds= vec_new(sub_r1r2);  
        *lbounds= vec_new(sub_r1r2);  


/*** Logarithms of the units  ************************************************/

               
    	if (!order_units_known (ord))      
	  order_units_indep_calc (ord);

        if (!order_units_logs_known(ord)) 
	  order_units_logs_calc (ord);
                                                                               
        units_logs= 0;
        mat_h1= 0;
        lll_real_d_reduce(R, order_units_logs (ord), 0.75, &units_logs, &mat_h1);
                   
        if (anf_print_level>=5)
         {     
	  printf("\nOrder for units: \n");
          order_write(ord);

          lll_units= vec_new(r);
          lll_units_log= mat_new(r+1, r);
          mat_int= mat_real_to_mat_z(R, mat_h1);
          for (i=1; i<=r; i++)
           {  
            elt_h1= 1;
            for (j=1; j<=r; j++)
             {
              elt_h2= anf_power(ord, order_unit(ord,j), mat_elt(mat_int,j,i) );
              elt_h3= elt_h1;
              elt_h1= anf_mult(ord, elt_h2, elt_h3); 
              anf_elt_delete(ord, &elt_h2);
              anf_elt_delete(ord, &elt_h3);
             }                                      
            vec_entry(lll_units, i)= elt_h1;
                             
	    anf_elt_logs_mat(ord, vec_entry(lll_units, i), lll_units_log, i);
           } 

          printf("\nUnits in R (LLL-reduced) in reference to rel_ord:\n\n");
	  for (i=1; i<=r; i++)      
           {  
	    for (j=1; j<=m; j++)      
             {             
              printf("(");
	      for (l=1; l<=n; l++)      
               {
                 printf("%d",anf_elt_coef(vec_entry(lll_units, i), (j-1)*n+l ));
                 if (l!=n)  printf(",");
               }                     
              if (j<m)
                printf("),    ");        
               else
                printf(")   ");        
             }
            anf_norm(ord, vec_entry(lll_units, i), &d1, &d2 );
            integer_delref(d1);
            integer_delref(d2);
            printf("\nnorm= %d \n", d1);
            printf("\n");
           }

          printf("\nLogs of units in R (LLL-reduced):\n");
	  mat_real_write_aj(R, lll_units_log,15 );
          printf("\n\n");

          printf("\nunits_logs (logs of  LLL-reduced units):\n");
	  mat_real_write_aj(R, units_logs,15 );
          printf("\n\n");

          reg = order_units_logs_reg_calc(ord, lll_units_log);
          printf("\nReg= ");
          real_write_aj(R, reg, 15);
          printf("\n");
          real_delete(&reg);


  	  mat_delref(Z, &mat_int);
  	  mat_delref(R, &lll_units_log);
          for (i=1; i<=r; i++)
            anf_elt_delete(ord, &vec_entry(lll_units, i));
          vec_delete(Z, &lll_units);
         }
  

                                                                    
        /* log |N_{K/F}^j(unit(l))|   */

        units_norms_log= vec_new(r);  


/*
          % Test: log |N_{K/F}^j(unit(l))|   

          units_norms_tst= vec_new(r);

          for (l=1;l<=r;l++)
   	    vec_entry(units_norms_tst,l)= anf_elt_rel_norms(ord, sub_ord, order_unit(ord,l), sort, 0);
  
          % Test: End                        
*/


        for (l=1;l<=r;l++)
         {
          vec_entry(units_norms_log,l)=  vec_new(n);	
                  
   	  for (j=1; j<= sub_r1r2; j++)  
	   {                        
            vec_entry(vec_entry(units_norms_log,l),j)= conv_int_to_real (R,0); 

 	    for (i=1; i<= anf_rel_sort_m(sort); i++)   
	     {                             
              ind=  anf_rel_sort_ordering_elt(sort,j,i);
              if (ind> r+1) 
                ind= ind- r2;
	      temp1= real_incref(mat_elt(units_logs,ind,l));  

              temp2= vec_entry(vec_entry(units_norms_log,l),j);
              vec_entry(vec_entry(units_norms_log,l),j)= real_add(R, temp1, temp2);
              real_delete(&temp1);
              real_delete(&temp2);
	     } 
	    if (j>sub_r1)  
              vec_entry(vec_entry(units_norms_log,l),j+sub_r2)= 
   	                     real_incref(vec_entry(vec_entry(units_norms_log,l),j));
	   }
         }









        if (anf_print_level>=3)
	 {
          printf("\norder units_logs: \n");
	  mat_real_write_aj(R,  order_units_logs (ord),15);  
          printf("\n \n");
          printf("\nunits_logs (lll), transf. matrix: \n");
	  mat_real_write_aj(R, units_logs,15);
          printf("\n \n");     
	  mat_real_write_aj(R, mat_h1,15);
	  printf("\n \n");
          

	  printf("log |N_{K/F}^j(unit(l))|: \n\n");
          for (l=1;l<=r;l++)
           {
            printf("\nunit(%d): \n", l);
	    mat_real_write_aj(R,vec_entry(units_norms_log,l),15);
            printf("\n");
/*
            for (j=1;j<=n;j++)
             {          
              temp1= real_log(R,vec_entry(vec_entry(units_norms_tst,l),j) );
              real_write_aj(R, temp1, 15);
              real_delete(&temp1);
             }
            printf("\n \n");
*/
           }
	   printf("\n\n\n\n");   
         }
      
/*** bounds    **************************************************************/

               
	for (j=1;j<=sub_r1r2;j++)
	{   
	 vec_entry(*ubounds,j)= vec_new(m);
	 vec_entry(*lbounds,j)= vec_new(m);  

         lambda_log = real_log(R, vec_entry(lambdas,j) );

	 /*  log|K^j| (2/(m log la^j)  */

	 temp1= conv_int_to_real (R,m);
	 temp2= real_log(R, vec_entry(K,j) );
	 sum3= real_divide(R, temp2, temp1);
	 real_delete(&temp1);
	 real_delete(&temp2); 

	 /*  |log|K^j|| (2/(m log la^j) */

	 sum4=  real_abs(R, sum3);

	 temp2= conv_int_to_real (R,2);
         temp4= real_divide(R, temp2, lambda_log);

         temp1= sum3;
         sum3= real_mult(R, temp1,temp4);
	 real_delete(&temp1);

         temp1= sum4;
         sum4= real_mult(R, temp1,temp4);
	 real_delete(&temp1);

	 real_delete(&temp2);   
	 real_delete(&temp4);   

         if (anf_print_level>=3)
	  {
	   printf("log|K^j| (2/(m log la^j)= ");
	   real_write_aj(R, sum3, 15);
	   printf("\n \n");   
	   printf("|log|K^j|| (2/(m log la^j)= ");
	   real_write_aj(R, sum4, 15);
	   printf("\n \n");
	  }

	 /*  (sum of |log|N^j(e_l)||)/ (log la^j)  */

         sum2= conv_int_to_real (R,0);
         for (l=1;l<=r;l++)
	  {    
	   temp3= real_abs(R, vec_entry(vec_entry(units_norms_log,l), j ));

           temp2= sum2;     
           sum2= real_add (R,temp3,temp2);
          
           real_delete (&temp2);
           real_delete (&temp3);  
          }
         temp1= sum2;
         sum2= real_divide(R, temp1,lambda_log);
	 real_delete(&temp1); 

         if (anf_print_level>=3)
	  {
	   printf("(sum of |log|N^j(e_l)||)/ (log la^j)= ");
	   real_write_aj(R, sum2, 15);
	   printf("\n \n");   
          }


         /*             */
         /* i- Schleife */
         /*             */

	 for (i=1;i<=m;i++)
    	  {                  
           /* (sum of log_units)m/2 */

           sum1= conv_int_to_real (R,0);
	   ind=  anf_rel_sort_ordering_elt(sort,j,i);

           for (l=1;l<=r;l++)
	    {    
             if ( ind <= r+1)
               temp1  = real_abs (R,mat_elt (units_logs,ind,l));
              else  
               temp1 = real_abs (R,mat_elt (units_logs,ind-r2,l));

             temp2= sum1;     
             sum1= real_add (R,temp1,temp2);
          
             real_delete (&temp1);
             real_delete (&temp2);
            }         

	    temp1= conv_int_to_real (R,m);
            temp2= real_divide(R, temp1, lambda_log);
	    temp3= sum1;
            sum1= real_mult(R, temp2, temp3);
	    real_delete(&temp1);
	    real_delete(&temp2);
	    real_delete(&temp3);

            if (anf_print_level>=3)
	     {
	      printf("\nrbounds: j,i,ind= %d, %d, %d\n\n",j,i,ind);
              printf("(sum of log_units)m/(log la^j)= ");
	      real_write_aj(R, sum1, 15);
	      printf("\n");
	     }

	    /* Upper bound */

	    temp1= real_add(R, sum1, sum2);
	    temp2= real_add(R, temp1, sum3);
	    temp3= real_add(R, temp2, sum4);
            vec_entry(vec_entry(*ubounds,j),i)= conv_real_to_int_ceil(R, temp3);
	    real_delete(&temp1);
	    real_delete(&temp2);
	    real_delete(&temp3);

	    /* Lower bound */
                  
            temp1= real_negate(R, sum1);
	    temp2= real_subtract(R, temp1, sum2);
	    temp3= real_subtract(R, temp2, sum3);
	    temp4= real_add(R, temp3, sum4);
            vec_entry(vec_entry(*lbounds,j),i)= conv_real_to_int_floor(R, temp4);
	    real_delete(&temp1);
	    real_delete(&temp2);
	    real_delete(&temp3);
	    real_delete(&temp4);


	    /* End of loop */

            real_delete (&sum1);

    	  }                  

           real_delete (&sum2);
           real_delete (&sum3);
           real_delete (&sum4);
           real_delete (&lambda_log);

	 }    

        for (l=1;l<=r;l++)
 	  vec_delete(R, &vec_entry(units_norms_log,l) );
        vec_delete(Z, &units_norms_log);
                                               

/*
        for (l=1;l<=r;l++)
 	  vec_delete(R, &vec_entry(units_norms_tst,l) );
        vec_delete(Z, &units_norms_tst);
*/

         
	mat_delref(R, &units_logs);
	mat_delref(R, &mat_h1);
	ring_delete(&Z);
          

/*** End    *****************************************************************/

	return;
 
}

