/******************************************************************************
  rel_lat_chol_calc.c                                                           
******************************************************************************/
#include "kant.h"
#include "rel_lattice.h"                

t_void
rel_lat_chol_calc WITH_1_ARG(
	rel_lattice,	rel_lat
)
/*******************************************************************************
 
Description:
 

 
Calling sequence:
 

 
History:
 
	92-03-12 KW    written
 
*******************************************************************************/
{
	block_declarations;

	integer_small	i, r1, r2, r1r2;   



	if (rel_lat_chol_known(rel_lat)) return;
                                  
	if (!rel_lat_gram_known(rel_lat)) rel_lat_gram_calc(rel_lat);

	r1= order_r1(rel_lat_coef_ord(rel_lat));
	r2= order_r2(rel_lat_coef_ord(rel_lat));
	r1r2= r1+r2;

	rel_lat_chol(rel_lat)= vec_new(r1r2);
	for  (i=1; i<= r1r2; i++)
  	  rel_lat_chol_con(rel_lat,i) =  mat_comp_gram_chol(rel_lat_gram_ring(rel_lat),
	                          rel_lat_gram_con(rel_lat,i),&rel_lat_chol_ring(rel_lat));
        
	rel_lat_chol_ring(rel_lat) = ring_incref(rel_lat_gram_ring(rel_lat));
 

}
