#include "kant.h"

t_logical
anf_rel_field_basis_test WITH_5_ARGS (order          , ord      ,
                                      order          , rel_ord  ,
                                      anf_elt        , my       ,
                                      dyn_arr_handle , gen      ,
                                      anf_ideal      , rel_disc  )

{
          block_declarations;

          anf_ideal      ideal;
          anf_elt        temp1, temp2, temp3, temp4, temp5;
          anf_elt        alpha;
 
          integer_big    d,abs_disc,temp,norm,den;

          t_logical      stimmt;
 
/* First of all compute the absolute disc of the field.    */
  order_disc_assure (ord);

  temp = integer_mult (order_disc (ord),order_disc (ord));

  anf_ideal_norm (ord,rel_disc,&norm,&den);
  abs_disc = integer_mult (norm,temp);

  integer_delref (den);
  integer_delref (temp);
  integer_delref (norm);

  if (dyn_arr_element (gen,0) == 2)
  {
  /* We have an relative basis so evaluate the disc of (1,gen(0)) */
  /* check if d(1,gen(0)) == rel_disc                             */

  /* We have : d(1,gen(0)) = 4*my * b^2 * z^(-2)                  */
  /* with gen (0) = z^(-1)*[a + b * sqrt(my)]                     */

    alpha = dyn_arr_element (gen,1);  

    temp1 = anf_elt_mult (ord,4,my);
    temp2 = anf_elt_mult (ord,anf_elt_coef (alpha,2),
                              anf_elt_coef (alpha,2) );
    temp3 = anf_elt_mult (ord,anf_elt_den (alpha),
                              anf_elt_den (alpha) );

    temp4 = anf_elt_mult (ord,temp1,temp2);
    temp5 = anf_elt_div (ord,temp4,temp3);

    if (anf_print_level > 5)
    {
      printf ("Der Erzeuger der Disc von (1 , ");
         anf_elt_write (rel_ord,alpha);
      printf (") ist : ");
         anf_elt_write (ord,temp5);puts ("");
    }
   
    ideal = anf_ideal_2_create (ord,temp5,temp5);

    if (!anf_ideal_different (ord,rel_disc,ideal))
    {
      if (anf_print_level > -1)
        puts ("TEST : BEI ALLEN GOETTERN DER ALGEBRA ... o(F) - BASIS");
      stimmt = TRUE;
    }
    else
      {
        puts ("================= FEHLER ======================");
        stimmt = FALSE;
      }
    
    anf_ideal_delete (ord,&ideal);
  
    anf_elt_delete (ord,&temp1);
    anf_elt_delete (ord,&temp2);
    anf_elt_delete (ord,&temp3);
    anf_elt_delete (ord,&temp4);
    anf_elt_delete (ord,&temp5);

   
    

 }
 else
   {
     d = anf_rel_field_basis_abs_disc (ord,rel_ord,my,gen);

     if (anf_print_level > 5)
     {
 
       cay_print ("disc of ZZ - gen . %d\n",d);
       cay_print ("abs disc           %d\n",abs_disc);
     }  
  

     if (integer_compare (d,abs_disc) == 0)
     {
       if (anf_print_level > -1)
         puts ("TEST : BEI ALLEN GOETTERN DER ALGEBRA ... ZZ - BASIS");
       stimmt = TRUE;
     }
     else
       {
         puts ("================= FEHLER (GEN) ======================");
         stimmt = FALSE;
       }
     
     integer_delref (d);

   }




  return stimmt;

}
