/******************************************************************************
  anf_ideal_simplify.c
******************************************************************************/
 
#include "stdio.h"        
#include "defs.h"
#include "anf.h"

t_void
anf_ideal_simplify WITH_2_ARGS(
	order,		ord,
	anf_ideal *,	id
)
/*******************************************************************************
 
Description:

	Simplifies Z-Basis- and 2-Element-Presentation of the
	ideal id.
  
Calling sequence:
 
        anf_ideal_simplify(ord, id);
 
        order   	ord:        order over which id is defined
        anf_ideal       id:	    ideal to be simplified
 
History:

	92-07-13 CO     first version

*******************************************************************************/
{       
	block_declarations;

	t_handle		z;
	anf_elt		hlp;
 
	order_must_be_over_z(ord);

	if(anf_ideal_is_z(*id))
	{
		z = m_z_str_incref(structure_z);                 
		mat_z_simplify ( z, anf_ideal_tran(*id), &anf_ideal_tran_den(*id) );           
		z_ring_delete(&z);
	}

	if(anf_ideal_is_2(*id))
	{
		hlp = anf_elt_simplify( ord, anf_ideal_gen1(*id));
		anf_elt_delete( ord, &anf_ideal_gen1(*id));
		anf_ideal_gen1(*id) = hlp;
		hlp = anf_elt_simplify( ord, anf_ideal_gen2(*id));
		anf_elt_delete( ord, &anf_ideal_gen2(*id));
		anf_ideal_gen2(*id) = hlp;
	}

	return;
}

