#include "defs.h"
#include "principal_ideal.e"

/*
 *	Coerce into a structure in principal_ideal
 */

t_logical principal_ideal_elt_coerce(target_s, s, e, it, new_e, new_it, do_error)
t_handle target_s, s, e, it, *new_e, *new_it;
t_logical do_error;
{
	t_pi_context    context;
	
	pi_ctx_init(target_s, &context);
	return pi_elt_coerce_ctx(&context,  s, e, it, new_e, new_it);
}

t_logical pi_elt_coerce_ctx(context, s, e, it, new_e, new_it)
t_pi_ctx	context;
t_handle s, e, it, *new_e, *new_it;
{
	t_handle	ring;
	t_pfl		elt_coerce;
	t_pfv		elt_delete;
	t_pfl		is_zero;
	t_pfh		elt_quotrem;
	t_logical	success;
	t_handle	g, r, temp;

	ring = m_pi_ctx_ring(context);
	g = m_pi_ctx_generator(context);
	elt_coerce = m_pi_ctx_elt_coerce(context);
	is_zero =  m_pi_ctx_is_zero(context);
	elt_quotrem = m_pi_ctx_elt_quotrem(context);
	elt_delete =  m_pi_ctx_elt_delete(context);
	ASSERT(elt_coerce);
	ASSERT(is_zero);
	ASSERT(elt_quotrem);
	ASSERT(elt_delete);

	/* Just coerce it into the ring - the representation is the same. */
	success = (*elt_coerce)(ring, s, e, it, &temp, new_it);
	if (!success)
	{
		return FALSE;
	}
	(*elt_quotrem)(ring, temp, g, new_e, &r);
	success = (*is_zero)(ring, r);
	(*elt_delete)(ring, &temp);
	(*elt_delete)(ring, &r);
	if (!success)
	{
		(*elt_delete)(ring, new_e);
		return FALSE;
	}
	return TRUE;
}
		
