#include "poly.h"
#include "globals.e"
#include "q.e"

t_integer poly_z_red_resultant(pring, apoly, bpoly)
t_handle        pring;
t_poly          apoly, bpoly;
{
	block_declarations;
	t_handle	pringq;
	t_poly		qapoly, qbpoly;
	t_poly		g, s, t, u, v;
	t_polyp		sp, tp;
	t_poly		temp, temp1;
	t_int		it;
	t_integer	ds, dt;
	t_integer	res;
	t_int		nterms, i;

	pringq = poly_str_create(structure_q, 1);
	poly_elt_coerce(pringq, pring, apoly, 0, &qapoly, &it);
	poly_elt_coerce(pringq, pring, bpoly, 0, &qbpoly, &it);
	poly_xgcd(pringq, qapoly, qbpoly, &g, &s, &t, &u, &v);
	poly_elt_delete(pringq, &u);
	poly_elt_delete(pringq, &v);
	res = (poly_deg(g) == 0);
	poly_elt_delete(pringq, &g);
	if (!res)
	{
		poly_elt_delete(pringq, &s);
		poly_elt_delete(pringq, &t);
		poly_str_delete(0, &pringq);
		return 0;
	}
	/* We find ds & dt  - denominators of s and t resp. */
	sp = m_poly_to_ptr(s);
	nterms = m_polyp_nterms(sp);
	ds = 1;
	for (i=0; i<nterms; i++)
	{
		temp = ds;
		temp1 = q_denom_fun(structure_q, m_polyp_coefft(sp, i));
		ds = integer_lcm(ds, temp1);
		integer_delref(temp);
		integer_delref(temp1);
	}
		
	tp = m_poly_to_ptr(t);
	nterms = m_polyp_nterms(tp);
	dt = 1;
	for (i=0; i<nterms; i++)
	{
		temp = dt;
		temp1 = q_denom_fun(structure_q, m_polyp_coefft(tp, i));
		dt = integer_lcm(dt, temp1);
		integer_delref(temp);
		integer_delref(temp1);
	}

	res = integer_lcm(ds, dt);
	integer_delref(ds);
	integer_delref(dt);
	poly_elt_delete(pringq, &s);
	poly_elt_delete(pringq, &t);
	poly_str_delete(0, &pringq);

	return res;
}
 
t_integer poly_z_red_discriminant(pring, apoly)
t_handle        pring;
t_poly          apoly;
{
	t_poly		der, res;

	der = poly_deriv_princvar(pring, apoly);
	res =  poly_z_red_resultant(pring, apoly, der);
	poly_elt_delete(pring, &der);
	return res;

}
