#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "error.e"

void
poly_z_quot_rem WITH_5_ARGS(
    t_handle,      pring,
    t_poly,     apoly,
    t_poly,     bpoly,
    t_poly *,   pqpoly,      /* quotient (to be set) */
    t_poly *,   prpoly       /* remainder (to be set) */
)
/*
*    IPOLY_QUOT_REM 
*    bpoly | apoly ,  Q = apoly/bpoly,  RPOLY = 0    or else
*    apoly = bpoly*QPOLY + rpoly with deg( rpoly ) minimal.
*/
{
    block_declarations;
    t_poly        blead;        /* leading coefficient for bpoly */
    t_poly        alead;        /* leading coefficient for apoly as */
                                   /*   it is decremented */
    integer_big      bdeg;         /* degree of polynomial bpoly */
    t_poly        bdashpoly;    /* temporary polynomial */
    t_poly        q1poly;       /* temporary polynomial */
    t_poly        qcoefft;      /* coefficient of a polynomial */
    t_poly        s;            /* remainder for intermediate calcs */
    t_int    degdiff;      /* difference in degree of 2 polys */
    t_handle           aph;          /* t_handle for apoly */
    t_handle           bph;          /* t_handle for bpoly */
    t_handle           q1ph;         /* t_handle for q1poly */
    t_poly        temp;
    t_poly        temp2;


    if (m_poly_const (apoly))
    {
        /* apoly and bpoly both constant */
        integer_quot_rem( apoly, bpoly, pqpoly, prpoly );
        return;
    }

    if (m_poly_const (bpoly))
    {
        /*    bpoly is const; apoly is a non-trivial polynomial */

        error_internal ("poly_z_quot_rem: lifting error \n");
        return;
    }

    /* both non-trivial polynomials */

    aph = m_poly_poly_to_handle( apoly );
    bph = m_poly_poly_to_handle( bpoly );

    if (( m_poly_princvar (aph)   != m_poly_princvar (bph))
     || ( m_poly_least_pvar (aph) != m_poly_least_pvar (bph)))
    {    
        error_internal ("poly_z_quot_rem: lifting error \n");
        return;
    }

    bdeg = poly_deg( bpoly );

    blead = poly_z_lead_coefft( pring, bpoly );
    bdashpoly = poly_z_reductum( pring, bpoly );
    *prpoly = m_poly_z_incref( pring, apoly );
    *pqpoly = poly_z_zero_poly (pring, apoly);

    /*    compute quotient terms */

    while ( ! poly_z_is_zero_poly (pring, *prpoly))
    {
        
        degdiff = poly_deg( *prpoly ) - bdeg;

        if ( degdiff < 0 )
        {
            /* degree(*prpoly) < degree(bpoly) */
            /* end condition satisfied         */

	    goto EXIT;
        }

        /*    continue, degree(*prpoly) >= degree(bpoly) */

        alead = poly_z_lead_coefft( pring, *prpoly );
        poly_z_quot_rem( pring, alead, blead, &qcoefft, &s );
	m_poly_z_delref( pring, alead );

        if ( ! poly_z_is_zero_poly (pring, s))
        {
            m_poly_z_delref( pring, qcoefft );
            m_poly_z_delref( pring, s );

	    goto EXIT;
        }

        /* continue, s == 0, fake delref of s */

        m_poly_create_empty(&q1ph, m_poly_princvar (aph),
                                             m_poly_least_pvar (aph), 1);
        q1poly = m_poly_handle_to_poly( q1ph );
        m_poly_coefft( q1ph, 0 ) = qcoefft;	/* transfer */
        m_poly_expt( q1ph, 0 ) = degdiff;

        temp = *pqpoly;
        *pqpoly = poly_z_add( pring, temp, q1poly );
        m_poly_z_delref( pring, temp );

	temp2 = poly_z_reductum( pring, *prpoly );
	m_poly_z_delref( pring, *prpoly );

	temp = poly_z_mult( pring, bdashpoly, q1poly );
	m_poly_z_delref( pring, q1poly );

        *prpoly = poly_z_subtract( pring, temp2, temp );
	m_poly_z_delref( pring, temp );
	m_poly_z_delref( pring, temp2 );
    }

EXIT:	;

    m_poly_z_delref( pring, blead );
    m_poly_z_delref( pring, bdashpoly );

    return;

} /* poly_z_quot_rem() */

