#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "error.e"

t_poly
poly_u_zm_mult WITH_4_ARGS(
        t_handle,       pring,
	integer_big,	mdig,
	t_poly,	apoly,
	t_poly,	bpoly
)
/*
** poly_u_zm_mult: modular polynomial product.
** apoly, bpoly are univariate polynomials over Zmdig in the same variable
** returns : ( apoly * bpoly ) mod mdig.
*/
{
	DENY ( m_poly_const (apoly) || m_poly_const (bpoly));
	DENY( ! m_poly_univariate (m_poly_poly_to_handle (apoly)) || ! m_poly_univariate (m_poly_poly_to_handle (bpoly)));

	DENY( m_poly_princvar( m_poly_poly_to_handle( apoly )) != m_poly_princvar( m_poly_poly_to_handle( bpoly )));

	return modpoly_mult( pring, mdig, apoly, bpoly );
}

