#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "poly_mat.h"

t_poly
poly_u_z_matrix_extract_poly (pring, Qmat, apoly, row)
t_handle	pring;
t_matrix	Qmat;
t_poly	apoly;
t_int		row;
/* Extracts the row from the matrix and forms the univariate
** polynomial in the same ring as apoly.
** Note : rows are numbered from 1
*/
{
/* Assume that rows in the matrix are stored
** as coefficients of the polynomial, 
** lowest order terms first.
*/

	t_int		pvar, lpvar, cols, pos;
	t_int		offset, i;
	t_handle	phl, aph;
	integer_big	coeff;
	block_declarations;

	aph = m_poly_poly_to_handle(apoly);
	cols = m_poly_mat_col(Qmat);
	offset = (row - 1)*cols;

	pvar = m_poly_princvar (aph);
	lpvar = m_poly_least_pvar (aph);

	m_poly_create_empty(&phl, pvar, lpvar, cols);

	pos = 0;
	for (i = 0; i < cols; i++)
	{
		coeff = m_poly_mat_entry(Qmat, offset + i + 1);
		if (coeff)
		{
			m_poly_coefft(phl, pos) = integer_incref(coeff);
			m_poly_expt(phl, pos) = i;
			pos++;
		}
	}
	m_poly_nterms(phl) = pos;

	return m_poly_handle_to_poly(phl);
}

t_matrix
poly_u_z_matrix_poly_to_row(pring, apoly, n)
t_handle	pring; 
t_poly	apoly;
t_int 		n;
/* 
** Makes apoly into a row vector (matrix) of coefficients
** low order terms first.
*/
{
	t_int		i, j, k;
	t_handle	aph;
	t_matrix		res;

	aph = m_poly_poly_to_handle(apoly);
	res = poly_mat_new(1, n);
	k = poly_deg( apoly) + 1;
	/* k is the number of terms in the vector for poly degree k - 1 */

	j = 0; /* position we are up to in the polynomial */
	for (i = 1; i <= k; i++) /* Position in the vector */
	{
		if (m_poly_expt(aph, j) == i-1)
		{
			m_poly_mat_entry(res, i) = m_poly_coefft(aph, j);
			j++;
		}
		else
			m_poly_mat_entry(res, i) = 0;

	}

	for (i = k + 1; i<= n; i++)
		m_poly_mat_entry(res, i) = 0;

	return res;
}
