
#include "defs.h"
#include "ring.h"
#include "mat.h"
#include "integer.e"


/*
 * This file includes
 *
 * 	mat_z_scalar()            - Checks if a matrix is scalar
 * 	mat_z_identity()          - Checks if a matrix is the identity
 * 	mat_z_zero()              - Checks if a matrix is the zero matrix
 * 	mat_z_scalar_common()     - (Private) Common sub function
 *
 */

Private Logical mat_z_scalar_common P_((t_handle, matrix, t_int));

Logical
mat_z_scalar WITH_2_ARGS(
t_handle,	cring,
matrix,	a
)
/*
 * Test a matrix to see if it is scalar.
 * Returns TRUE if so.
 * "a" must be a square matrix
 *
 * "cring" is the coefficient ring.
 * Calls mat_z_scalar_common
 */
{
	matrix	mata;
	Logical	 result;

	mata = 0;
	mat_create_unpkd(cring, a, mata, mat_row(a), mat_col(a));

	result = mat_z_scalar_common(cring, mata, mat_entry(mata, 1));

	mat_free_unpkd(a, mata);
	return result;
}




Logical
mat_z_identity WITH_2_ARGS(
t_handle,	cring,
matrix,	a
)
/*
 * Test a matrix to see if it is the identity
 * Returns TRUE if so.
 *
 * "cring" is the coefficient ring.
 * Calls mat_z_scalar_common
 */
{
	matrix	mata;
	Logical	 result;

	mata = 0;
	mat_create_unpkd(cring, a, mata, mat_row(a), mat_col(a));

	result = mat_z_scalar_common(cring, mata, 1);

	mat_free_unpkd(a, mata);
	return result;
}



Logical
mat_z_zero WITH_2_ARGS(
t_handle,	ring,
matrix,	a
)
/*
 * Test a matrix to see if it is the zero matrix.
 * Returns TRUE if so.
 *
 * "a" can be m x n.
 */
{
	register t_int	i;
	register t_int	dsquared;
	register t_int	*ptr_mat;
	t_int		m;
	t_int		n;
	matrix	mata = 0;

	m = mat_row(a);		 n = mat_col(a);

	mat_create_unpkd(ring, a, mata, m, n);

	ptr_mat = mat_elt0_ptr(mata);
	dsquared = m * n;
	/*
	 * Scan each element of the matrix.
	 * i represents index to mata.
	 */
	for (i = 1; i <= dsquared; i++)
	{
		/*
		 * should be zero
		 */
		if (ptr_mat[i] != 0)
		{
			mat_free_unpkd(a, mata);
			return FALSE;
		}
	}

	mat_free_unpkd(a, mata);
	return TRUE;
}



Private Logical
mat_z_scalar_common WITH_3_ARGS(
t_handle,	ring,
matrix,	mata,
t_int,	scval
)
/*
 * Test a matrix to see if it is scalar, where the scalar value is "scval".
 * Called by scalar and identity.
 * "mata" is assumed to be UNPACKED.
 *
 * "ring" is the coefficient ring.
 */
{
	register t_int	col;
	register t_int	row;
	register t_int	i;
	register t_int	*ptr_mat;
	register t_int	n;

	n = mat_row(mata);
	if (n != mat_col(mata))
		error_internal("Matrix not square in SCALAR");

	ptr_mat = mat_elt0_ptr(mata);
	/*
	 * i represents index to mata
	 */
	i = 0;
	/*
	 * Scan each element of the matrix
	 */
	for (row = 1; row <= n; row++)
		for (col = 1; col <= n; col++)
			if (row == col)
			{
				/*
				 * Diagonal entry
				 */
				if (integer_compare(ptr_mat[++i], scval))	/* does not equal scval */
					return FALSE;
			}
			else
			{
				/*
				 * Non-diagonal (should be zero)
				 */
				if (integer_compare(ptr_mat[++i], 0))	/* does not equal zero */
					return FALSE;
			}

	return TRUE;
}


