#include "defs.h"
#include "integer.e"
#include "q.e"
#include "ring.h"
#include "mat.h"
#include "zm.e"

t_void
mat_incref_entries WITH_2_ARGS(
	t_handle,		ring,
	matrix,		mat
)
/*
 * Given a t_handle to a matrix, increment reference count to
 * each element of the matrix.
 */

{
	block_declarations;
	register integer_big	modulus;
	register t_int	i;
	register t_int	ringtype;
	register t_int	num_elems;
	register t_int	*ptr_mat;

	if ( mat_is_packed( mat ))
	{
		return;
	}

	num_elems = mat_row(mat) * mat_col(mat);
	ringtype = ring_type(ring);
	ptr_mat = mat_elt0_ptr(mat);
	/*
	 * increment reference counters of mat, if required
	 */
	switch (ringtype)
	{
	case RING_ZM:
			modulus = zm_modulus(ring);
			if (integer_is_single(modulus))
				break;
	case RING_Z:
			for (i = 1; i <= num_elems; i++)
				integer_incref(ptr_mat[i]);
			break;
	case RING_Q:
			for (i = 1; i <= num_elems; i++)
				q_incref(ptr_mat[i]);
			break;
	default:
			for (i = 1; i <= num_elems; i++)
				ring_elt_incref(ring, ptr_mat[i]);
	}
}
