#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"

integer_small
integer_num_decimal_digits(aint)
integer_big	aint;
{
	block_declarations;

	integer_small	dig;
	integer_big	adash;
	integer_big	temp;
	integer_small	count;

	/*
	 * Input:  aint - general integer
	 * Output: imxdig = estimate of number of digits in aint (maximum)
	 * imxdig computes the maximum possible number of digits in aint.
	 */

	adash = integer_incref(aint);
	count = 0;
	do
	{
		integer_quot_rem(adash, THETA, &temp, &dig);
		count++;
		integer_delref(adash);
		adash = temp;
	}
	while (integer_compare(adash, 0) != 0);
	/*
	 * At end of loop, count is the number of THETA digits for aint.
	 * Each THETA-digit is ETA digits long, except for the most significant
	 * one, which is the last one computed and which is stored in dig.
	 */

	return (count - 1) * ETA + idig(dig);
}
