/******************************************************************************
  mat_z_to_mat_real.c
******************************************************************************/
 
#include "stdio.h"        
#include "kant.h"
#include "mat.h"
#include "conv.e"

matrix
mat_z_to_mat_real WITH_2_ARGS(
	t_handle,		reals,
	matrix,	        mat
)
/*******************************************************************************
 
Description:
 
	Casts an integer matrix into a real matrix.
 
  
Calling sequence:
 
	mat = mat_z_to_mat_real(R, matz);
 
      	t_handle      R        = t_handle of reals field
      	matrix      matz     = integer matrix to be stored
 
  
History:
 
	91-10-11 JS    minor changes
	91-10-01 JS    written
 
*******************************************************************************/
{
	integer_small	m, n, i, j;
	matrix		matr;
 
        m = mat_row(mat);
        n = mat_col(mat);
 
	matr = mat_new(m, n);
                                  
	for (i=1; i<=m; ++i)
	{
		{
		for (j=1; j<=n; ++j)
			mat_elt(matr, i, j) = conv_int_to_real(reals, 
							mat_elt(mat, i, j));
		}
	}
 
	return matr;
}
 


