/*******************************************************************************
anf_ideal_is_in_faclst.c
*******************************************************************************/

#include "kant.h"





integer_small 
anf_ideal_is_in_faclst WITH_3_ARGS ( order       , ord,
                                     anf_ideal   , ideal,
                                     t_handle    , fac )
/*******************************************************************************
 
Description:
 
    Checks whether or not a given ideal is already part of a faclst.

 
Calling sequence:
 
 
      	order  	      ord         : order of a field.
        anf_ideal     ideal       : the ideal we are looking for in fac.

        fac           faclst      : the checked faclst.
                                                       
        t_logical     found       : = TRUE iff ideal is in fac.


            found =  anf_ideal_is_in_faclst (ord,ideal,fac);

History:                                          
 
	92-09-07 MD     written
 
*******************************************************************************/

{                   
               block_declarations;

               integer_small     i,len;
               t_logical           ok;


  if ( fac == MEM_NH ) return -1;

  len = m_poly_z_faclst_len (fac);
  if (len == 0) return -1;

  i = 0;


  while (   (i<len)
         && (ok = anf_ideal_different (ord,ideal,m_poly_z_faclst_factor (fac,i))) )

    i++;

  if (!ok)   /* We found the ideal in the fac */ 
    return i;
  else
    return -1;


} 







