/******************************************************************************
  anf_ideal_div_casc.c
******************************************************************************/
 
#include "kant.h"        


t_void
anf_ideal_div_casc WITH_2_ARGS(
	order,		ord,
	t_handle * ,	ids
)
/*******************************************************************************
 
Description:
             
	Computes a basis of the ideals given in the ideal factor
	list "ids" with use of divisor cascading.
	After this routine "ids" will contain the new basis.
  
Calling sequence:
 
        order   	ord:    order over which ideals in "ids" are defined
	t_handle*	ids:	ideal factor list
 
History:

	92-12-21 CO	general version (ideals need not be over same p*oF)
	92-09-16 CO	first version

*******************************************************************************/
{       
	block_declarations;
 
	anf_ideal	gcd, rest_i, rest_j;
	t_int		k, i, j, kt;
	integer_big	norm_g, den_g, norm_i, den_i, norm_j, den_j;


	k = 0; kt = 0; /* count number of (trivial) gcd calculations */

        if( anf_print_level > 1 )
		printf("\ninput ideal list consists of %d elements\n",
			m_poly_z_faclst_len( *ids ) );

	for( i = 0; i < m_poly_z_faclst_len( *ids ) - 1; i++ )
	{
	    for( j = i+1; j < m_poly_z_faclst_len( *ids ); j++ )
	    {
		k++;

		gcd = anf_ideal_gcd( ord, m_poly_z_faclst_factor( *ids, i ),
					m_poly_z_faclst_factor( *ids, j ) );
		anf_ideal_norm( ord, gcd, &norm_g, &den_g );

		if( anf_print_level > 6 )
		{
		    printf("\nactual faclst =\n");
		    anf_ideal_faclst_write( ord, *ids );
		    printf(" i=%d, j=%d, gcd = , norm( gcd ) =\n",i,j);
		    anf_ideal_z_write( ord, gcd );
		    integer_write( norm_g );puts("");
		}
/*
gcd is not trivial ?
*/
		if ( integer_compare( norm_g, 1 ) == 1 )
		{
		    rest_i = anf_ideal_divide_out_ideal( ord, 
				m_poly_z_faclst_factor( *ids, i ), gcd );
		    rest_j = anf_ideal_divide_out_ideal( ord, 
				m_poly_z_faclst_factor( *ids, j ), gcd );
		    anf_ideal_norm( ord, rest_i, &norm_i, &den_i );
		    anf_ideal_norm( ord, rest_j, &norm_j, &den_j );

		    anf_ideal_delete( ord,
			&m_poly_z_faclst_factor( *ids, i ));
/*
case  ideal(i) <> power of gcd  and  ideal(j) <> power of gcd:
 ideal(i) := rest(i); ideal(j) := rest(j); add gcd to factor list
*/
		    if( integer_compare( norm_i, 1 ) == 1 )
		    {
			m_poly_z_faclst_factor( *ids, i ) = rest_i;

			anf_ideal_delete( ord,
			    &m_poly_z_faclst_factor( *ids, j ));

			if( integer_compare( norm_j, 1 ) == 1 )
			{
			    m_poly_z_faclst_factor( *ids, j ) = rest_j;

			    anf_ideal_add_to_faclst( ord, ids, gcd, 1 );
			    anf_ideal_delete( ord, &gcd );

			    if( anf_print_level > 1 )
				printf("\nlength of ideal list enlarged to %d",
          				m_poly_z_faclst_len( *ids ) );
			}
/*
case  ideal(i) <> power of gcd  and  ideal(j) = power of gcd:
 ideal(i) := rest(i); ideal(j) := gcd
*/
			else
			{
			    m_poly_z_faclst_factor( *ids, j ) = gcd;
			    anf_ideal_delete( ord, &rest_j );
			    j--;
			}
		    }
/*
case  ideal(i) = power of gcd  and  ideal(j) <> power of gcd:
 ideal(i) := gcd; ideal(j) := rest(j)
*/
		    else
		    {
			anf_ideal_delete( ord, &rest_i );

			m_poly_z_faclst_factor( *ids, i ) = gcd;

			if( integer_compare( norm_j, 1 ) == 1 )
			{
			    anf_ideal_delete( ord,
				    &m_poly_z_faclst_factor( *ids, j ));
			    m_poly_z_faclst_factor( *ids, j ) = rest_j;
			}
/*
case  ideal(i) = power of gcd  and  ideal(j) = power of gcd:
 ideal(i) := gcd; throw away ideal(j)
*/
			else
			{
			    anf_ideal_take_out_of_faclst( ids, ord, j );
			    anf_ideal_delete( ord, &rest_j );

			    if( anf_print_level > 1 )
				printf("\nlength of ideal list reduced to  %d",
          				m_poly_z_faclst_len( *ids ) );
			}
			j--;
		    }
		    integer_delref( norm_g );
		    integer_delref( norm_i );
		    integer_delref( norm_j );
		}
		else
		{
		    anf_ideal_delete( ord, &gcd );
		    kt++;
		}
	    }
	}
	if( anf_print_level > 0 )
	{
		puts("");
		printf("\nanf_ideal_div_casc: mult. basis =\n");
		anf_ideal_faclst_write( ord, *ids );
		printf("\ntotal number of gcd calculations: %d\n", k );
		printf("\nnumber of trivial gcd calculations: %d\n", kt );
	}
}
