#include <stdio.h>         
#include "kant.h" 
#include "anf.h" 
#include "real.e"
#include "comp.e"



t_comp
anf_elt_ith_con WITH_3_ARGS(
	order,		ord,
	anf_elt, 	alpha,
	integer_small,	i	
)       
/*******************************************************************************
 
Description:
 
	Determines the i-th conjugate of an algebraic element 
	(as a complex number).
 
Calling sequence:
 
	con= anf_elt_ith_con(ord, alpha, i);
 
	order		ord		= t_handle of an order
        anf_elt		alpha		= algebraic element in in ord
	integer_small	i		= i-th conjugate will be produced
	t_comp		con		= the i-th conjugate

 
History:
 
	92-04-02 MJ/AJ Introducing C and change 
                         con= comp_make(R, re, im);  
                         to
                         con= comp_make(C, re, im);    
                       Maybe, some day, there is macro order_comp(ord);

	92-04-02 AJ    written
 
*******************************************************************************/
{  
	block_declarations;         

	int		r1, r2, n;
   	t_handle          R, Z, C;                        
	t_real		re, im, zero, sq2, temp1;
	t_comp		con; 
	anf_elt		beta;
                                    

/*** Initialisation **********************************************************/

	n=  order_abs_degree(ord);  
        r1= order_r1(ord);
        r2= order_r2(ord);

        Z= m_z_str_incref(structure_z);
        R = order_reals(ord);    
        C = comp_create(real_dec_prec(R));
	zero= conv_int_to_real(R,0);
	sq2=  order_sqrt_2(ord);


/*** beta will contain the conjugate vector **********************************/
    

      	if (anf_elt_is_con(alpha))
		beta = anf_elt_incref(alpha);
	else
		beta = anf_elt_con(ord, alpha);
                          
/*** The i-th conjugate  ****************************************************/

	if (i<=r1)
	  {
  	   re=  real_incref(anf_con(beta, i));
	   im=  real_incref(zero); 
	  }  
	 else
	  if (i<=(r1+r2))
	    {
  	     re=  real_divide(R,anf_con(beta, i), sq2);
	     im=  real_divide(R,anf_con(beta, i+r2),sq2);
 	    }
	   else
	    {
	     re=     real_divide(R,anf_con(beta, i-r2),sq2);
	     temp1=  real_negate(R, anf_con(beta, i));
             im=     real_divide(R, temp1, sq2);
	     real_delete(&temp1);
	    }

        con= comp_make(C, re, im);  
	real_delete(&re);
	real_delete(&im);
	
/*** End *********************************************************************/

	anf_elt_delete(ord, &beta);
	real_delete(&zero);
	ring_delete(&Z);
	ring_delete(&C);

	return con;  

} 

