/******************************************************************************
  anf_elt_is_zero.c                                                           
******************************************************************************/
                 
#include "kant.h"

t_logical
anf_elt_is_zero WITH_2_ARGS(
	order,		ord,
	anf_elt,	alpha
)
/*******************************************************************************
 
Description:
 
	Returns TRUE if alpha is 0.
 
  
Calling sequence:
 
	if (anf_elt_is_zero(ord, alpha)) ...
 
      	order       ord   = t_handle of order alpha, beta are given referring to
        anf_elt     alpha = algebraic number 
     
History:
 
	92-09-07 JS    first version

*******************************************************************************/
{       
	block_declarations;
 
	integer_big     a;
        t_logical         result;
                                   
        if (anf_elt_is_integer_sub(ord, alpha, &a))
        {
                result = (a == 0);
                integer_delref(a);
		return result;
        }
 
        return 0;
} 

